/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.api.util;

import hudson.plugins.backlog.api.entity.Issue;
import hudson.plugins.backlog.api.entity.Priority;
import hudson.plugins.backlog.api.entity.Project;
import hudson.plugins.backlog.api.entity.User;
import hudson.plugins.backlog.api.util.DateUtil;
import hudson.plugins.backlog.api.util.StringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ConvertUtil {
    private ConvertUtil() {
    }

    public static Project responseToProject(Object response) {
        if (response == null) {
            return null;
        }
        Map map = (Map)response;
        if (map.isEmpty()) {
            return null;
        }
        int id = (Integer)map.get("id");
        String name = (String)map.get("name");
        String key = (String)map.get("key");
        String url = (String)map.get("url");
        return new Project(id, name, key, url);
    }

    public static Issue responseToIssue(Object response) {
        if (response == null) {
            return null;
        }
        Map map = (Map)response;
        if (map.isEmpty()) {
            return null;
        }
        String key = (String)map.get("key");
        String summary = (String)map.get("summary");
        String description = (String)map.get("description");
        String url = (String)map.get("url");
        Date startDate = ConvertUtil.responseToDate(map.get("start_date"));
        Date dueDate = ConvertUtil.responseToDate(map.get("due_date"));
        Double estimatedHours = (Double)map.get("estimated_hours");
        Double actualHours = (Double)map.get("actual_hours");
        String issueType = null;
        Map issueTypeObj = (Map)map.get("issueType");
        if (issueTypeObj != null) {
            issueType = (String)issueTypeObj.get("name");
        }
        String[] components = null;
        Object[] componentObjs = (Object[])map.get("components");
        if (componentObjs != null) {
            components = new String[componentObjs.length];
            for (int i = 0; i < componentObjs.length; ++i) {
                Map componentObj = (Map)componentObjs[i];
                components[i] = (String)componentObj.get("name");
            }
        }
        String[] affectsVersions = null;
        Object[] affectsVersionObjs = (Object[])map.get("versions");
        if (affectsVersionObjs != null) {
            affectsVersions = new String[affectsVersionObjs.length];
            for (int i = 0; i < affectsVersionObjs.length; ++i) {
                Map affectsVersionObj = (Map)affectsVersionObjs[i];
                affectsVersions[i] = (String)affectsVersionObj.get("name");
            }
        }
        String[] milestoneVersions = null;
        Object[] milestoneObjs = (Object[])map.get("milestones");
        if (milestoneObjs != null) {
            milestoneVersions = new String[milestoneObjs.length];
            for (int i = 0; i < milestoneObjs.length; ++i) {
                Map milestoneObj = (Map)milestoneObjs[i];
                milestoneVersions[i] = (String)milestoneObj.get("name");
            }
        }
        Priority priority = Priority.MIDDLE;
        Map priorityObj = (Map)map.get("priority");
        if (priorityObj != null) {
            priority = Priority.getPriorityFromId((int)((Integer)priorityObj.get("id")));
        }
        String resolution = null;
        Map resolutionObj = (Map)map.get("resolution");
        if (resolutionObj != null) {
            resolution = (String)resolutionObj.get("name");
        }
        String status = null;
        Map statusObj = (Map)map.get("status");
        if (statusObj != null) {
            status = (String)statusObj.get("name");
        }
        User assignerUser = ConvertUtil.responseToUser(map.get("assigner"));
        User createdUser = ConvertUtil.responseToUser(map.get("created_user"));
        Date createdOn = ConvertUtil.responseToDatetime(map.get("created_on"));
        Date updatedOn = ConvertUtil.responseToDatetime(map.get("updated_on"));
        return new Issue(key, summary, description, url, startDate, dueDate, estimatedHours, actualHours, issueType, components, affectsVersions, milestoneVersions, priority, resolution, status, assignerUser, createdUser, createdOn, updatedOn);
    }

    public static Date responseToDate(Object value) {
        if (value == null || value.equals("")) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("illegal date type " + value);
        }
        String dateString = (String)value;
        if (dateString.length() != 8) {
            throw new IllegalArgumentException("illegal date format " + value);
        }
        try {
            Date date = DateUtil.parseYyyyMMddHHmmssSSS((String)dateString);
            return date;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Date responseToDatetime(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("illegal date type " + value);
        }
        String dateString = (String)value;
        if (dateString.length() != 14) {
            throw new IllegalArgumentException("illegal date format " + value);
        }
        try {
            Date date = DateUtil.parseYyyyMMddHHmmssSSS((String)StringUtil.fill((String)dateString, (int)16, (char)'0'));
            return date;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static User responseToUser(Object value) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (map.isEmpty()) {
            return null;
        }
        String name = (String)map.get("name");
        int id = (Integer)map.get("id");
        Date updatedOn = ConvertUtil.responseToDatetime(map.get("updated_on"));
        User user = new User(name, id, updatedOn);
        return user;
    }

    public static Map<String, Object> issueToRequest(Issue issue) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        if (issue.getSummary() != null) {
            request.put("summary", issue.getSummary());
        }
        if (issue.getDescription() != null) {
            request.put("description", issue.getDescription());
        }
        if (issue.getStartDate() != null) {
            request.put("start_date", DateUtil.formatYyyyMMdd((Date)issue.getStartDate()));
        }
        if (issue.getDueDate() != null) {
            request.put("due_date", DateUtil.formatYyyyMMdd((Date)issue.getDueDate()));
        }
        if (issue.getEstimatedHours() != null) {
            request.put("estimated_hours", issue.getEstimatedHours());
        }
        if (issue.getActualHours() != null) {
            request.put("actual_hours", issue.getActualHours());
        }
        if (issue.getIssueType() != null) {
            request.put("issueType", issue.getIssueType());
        }
        if (issue.getComponents() != null) {
            request.put("component", Arrays.asList(issue.getComponents()));
        }
        if (issue.getAffectsVersions() != null) {
            request.put("version", Arrays.asList(issue.getAffectsVersions()));
        }
        if (issue.getMilestoneVersions() != null) {
            request.put("milestone", Arrays.asList(issue.getMilestoneVersions()));
        }
        if (issue.getPriority() != null) {
            request.put("priorityId", issue.getPriority().getId());
        }
        if (issue.getAssignerUser() != null) {
            request.put("assignerId", issue.getAssignerUser().getId());
        }
        return request;
    }
}

