/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.api.util;

import hudson.plugins.backlog.api.util.StringUtil;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String formatYyyyMMdd(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String dateString = StringUtil.fill((String)String.valueOf(calendar.get(1)), (int)-4, (char)'0') + StringUtil.fill((String)String.valueOf(calendar.get(2) + 1), (int)-2, (char)'0') + StringUtil.fill((String)String.valueOf(calendar.get(5)), (int)-2, (char)'0');
        return dateString;
    }

    public static Date parseYyyyMMddHHmmssSSS(String dateString) throws IllegalArgumentException {
        Calendar calendar = Calendar.getInstance();
        if (dateString == null || dateString.equals("")) {
            throw new IllegalArgumentException("Invalid String to Parse as Date - dateString was null or empty");
        }
        int strSize = dateString.length();
        if (strSize < 8) {
            throw new IllegalArgumentException("Invalid String to Parse as Date - dateString invalid string length (" + strSize + ")");
        }
        String filled = StringUtil.fill((String)dateString, (int)17, (char)'0');
        String yearStr = filled.substring(0, 4);
        String monthStr = filled.substring(4, 6);
        String dayStr = filled.substring(6, 8);
        String hourStr = filled.substring(8, 10);
        String minuteStr = filled.substring(10, 12);
        String secondsStr = filled.substring(12, 14);
        String millisStr = filled.substring(14, 17);
        int year = 0;
        int day = 0;
        int month = 0;
        int hour = 0;
        int minute = 0;
        int seconds = 0;
        int millis = 0;
        try {
            year = Integer.parseInt(yearStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + yearStr + "' as a valid year", e);
        }
        try {
            day = Integer.parseInt(dayStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + dayStr + "' as a valid day", e);
        }
        try {
            month = Integer.parseInt(monthStr) - 1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + monthStr + "' as a valid month", e);
        }
        try {
            hour = Integer.parseInt(hourStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + hourStr + "' as a valid hour", e);
        }
        try {
            minute = Integer.parseInt(minuteStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + minuteStr + "' as a valid minute");
        }
        try {
            seconds = Integer.parseInt(secondsStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + secondsStr + "' as a valid seconds");
        }
        try {
            millis = Integer.parseInt(millisStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse '" + millisStr + "' as a valid millis");
        }
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(1, year);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, seconds);
        calendar.set(14, millis);
        Date date = calendar.getTime();
        return date;
    }
}

