/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.backlog.Messages;
import hudson.plugins.backlog.api.BacklogApiClient;
import hudson.plugins.backlog.api.entity.Issue;
import hudson.plugins.backlog.api.entity.Priority;
import hudson.plugins.backlog.api.entity.Project;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailSender;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.xmlrpc.XmlRpcException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacklogNotifier
extends Notifier {
    public final String space;
    public final String projectKey;
    public final String userId;
    public final String password;

    @DataBoundConstructor
    public BacklogNotifier(String space, String projectKey, String userId, String password) {
        this.space = space;
        this.projectKey = projectKey;
        this.userId = userId;
        this.password = password;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.SUCCESS) {
            return true;
        }
        AbstractBuild pb = (AbstractBuild)build.getPreviousBuild();
        if (pb == null || pb.getResult() != Result.SUCCESS) {
            return true;
        }
        BacklogApiClient client = new BacklogApiClient();
        try {
            client.login(this.space, this.userId, this.password);
        }
        catch (IllegalArgumentException e) {
            listener.getLogger().println(e.getMessage());
            return true;
        }
        try {
            Project project = client.getProject(this.projectKey);
            MimeMessage message = new MessageCreator(build, listener).getMessage();
            Issue newIssue = new Issue();
            newIssue.setSummary(message.getSubject());
            newIssue.setDescription(message.getContent().toString());
            if (build.getResult() == Result.FAILURE) {
                newIssue.setPriority(Priority.HIGH);
            } else if (build.getResult() == Result.UNSTABLE) {
                newIssue.setPriority(Priority.MIDDLE);
            }
            Issue issue = client.createIssue(project.getId(), newIssue);
            listener.getLogger().println("Created issue is [" + issue.getKey() + "] : " + issue.getUrl());
        }
        catch (XmlRpcException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (MessagingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.BacklogNotifier_DisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageCreator
    extends MailSender {
        private static final Pattern URL_MATCH_PATTERN = Pattern.compile("(http://|https://){1}[\\w\\.\\-/:\\#\\?\\=\\&\\;\\%\\~\\+]+", 2);
        private AbstractBuild<?, ?> build;
        private BuildListener listener;

        public MessageCreator(AbstractBuild<?, ?> build, BuildListener listener) {
            super("", false, false);
            this.build = build;
            this.listener = listener;
        }

        public MimeMessage getMessage() throws MessagingException, InterruptedException, IOException {
            MimeMessage message = this.getMail(this.build, this.listener);
            Matcher matcher = URL_MATCH_PATTERN.matcher(message.getContent().toString());
            String textWithSpaces = matcher.replaceAll(" $0 ");
            message.setText(textWithSpaces);
            return message;
        }
    }
}

