/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.backlog.BacklogLinkAction;
import hudson.plugins.backlog.Messages;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BacklogProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final String projectURL;
    public final String spaceURL;

    @DataBoundConstructor
    public BacklogProjectProperty(String spaceURL) {
        String tempS = null;
        String tempP = null;
        if (spaceURL != null && spaceURL.length() > 0) {
            if (spaceURL.indexOf("/projects/") > -1) {
                tempS = spaceURL.substring(0, spaceURL.indexOf("/projects/") + 1);
                tempP = spaceURL.substring(0, spaceURL.endsWith("/") ? spaceURL.length() - 1 : spaceURL.length());
            } else {
                tempS = !spaceURL.endsWith("/") ? spaceURL + '/' : spaceURL;
            }
        }
        this.spaceURL = tempS;
        this.projectURL = tempP;
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new BacklogLinkAction(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(BacklogProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.BacklogProjectProperty_DisplayName();
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            BacklogProjectProperty bpp = (BacklogProjectProperty)((Object)req.bindJSON(BacklogProjectProperty.class, formData));
            if (bpp.spaceURL == null) {
                bpp = null;
            }
            return bpp;
        }
    }
}

