// CHECKSTYLE:OFF

package org.jvnet.hudson.plugins.backup;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * This file is a directory
     * 
     */
    public static String fileIsADirectory() {
        return holder.format("fileIsADirectory");
    }

    /**
     * This file is a directory
     * 
     */
    public static Localizable _fileIsADirectory() {
        return new Localizable(holder, "fileIsADirectory");
    }

    /**
     * File already exists, if you continue, it will be overridden.
     * 
     */
    public static String fileAlreadyExists() {
        return holder.format("fileAlreadyExists");
    }

    /**
     * File already exists, if you continue, it will be overridden.
     * 
     */
    public static Localizable _fileAlreadyExists() {
        return new Localizable(holder, "fileAlreadyExists");
    }

    /**
     * Backup manager
     * 
     */
    public static String display_name() {
        return holder.format("display_name");
    }

    /**
     * Backup manager
     * 
     */
    public static Localizable _display_name() {
        return new Localizable(holder, "display_name");
    }

    /**
     * File does not exist.
     * 
     */
    public static String fileNotExists() {
        return holder.format("fileNotExists");
    }

    /**
     * File does not exist.
     * 
     */
    public static Localizable _fileNotExists() {
        return new Localizable(holder, "fileNotExists");
    }

    /**
     * Backup or Restore Hudson configuration files
     * 
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Backup or Restore Hudson configuration files
     * 
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * File name is required.
     * 
     */
    public static String emptyFileName() {
        return holder.format("emptyFileName");
    }

    /**
     * File name is required.
     * 
     */
    public static Localizable _emptyFileName() {
        return new Localizable(holder, "emptyFileName");
    }

}
