/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup;

import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.backup.Messages;
import org.jvnet.hudson.plugins.backup.utils.BackupPluginTask;
import org.jvnet.hudson.plugins.backup.utils.BackupTask;
import org.jvnet.hudson.plugins.backup.utils.RestoreTask;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.LargeText;

public class BackupLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(BackupLink.class.getName());
    private BackupPluginTask task;
    private boolean fileNameOk = false;

    public String getIconFileName() {
        return "/plugin/backup/images/backup-48x48.png";
    }

    public String getUrlName() {
        return "backup";
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public boolean doBackupFileNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        this.fileNameOk = false;
        new /* Unavailable Anonymous Inner Class!! */.process();
        return this.fileNameOk;
    }

    public boolean doRestoreFileNameCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        this.fileNameOk = true;
        new /* Unavailable Anonymous Inner Class!! */.process();
        return this.fileNameOk;
    }

    public void doDoBackup(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="backupFileName") String fileName, @QueryParameter(value="verbose") boolean verbose) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        LOGGER.info("Backuping hudson files into " + fileName + "....");
        if (!this.doBackupFileNameCheck(req, rsp)) {
            rsp.sendRedirect("configurebackup");
            return;
        }
        this.task = new BackupTask();
        this.task.setVerbose(verbose);
        this.task.setLogFileName(this.getBackupLogFile().getAbsolutePath());
        this.task.setFileName(fileName);
        this.task.setConfigurationDirectory(this.getRootDirectory());
        Thread thread = Executors.defaultThreadFactory().newThread((Runnable)this.task);
        thread.start();
        rsp.sendRedirect("backup");
    }

    public void doDoRestore(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="restoreFileName") String fileName, @QueryParameter(value="verbose") boolean verbose) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        LOGGER.info("Restoring hudson files from " + fileName + "....");
        if (!this.doRestoreFileNameCheck(req, rsp)) {
            rsp.sendRedirect("configurerestore");
            return;
        }
        this.task = new RestoreTask(req.getServletContext());
        this.task.setFileName(fileName);
        this.task.setVerbose(verbose);
        this.task.setLogFileName(this.getRestoreLogFile().getAbsolutePath());
        this.task.setConfigurationDirectory(this.getRootDirectory());
        Thread thread = Executors.defaultThreadFactory().newThread((Runnable)this.task);
        thread.start();
        rsp.sendRedirect("restore");
    }

    public void doProgressiveBackupLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressiveLog(req, rsp, this.getBackupLogFile());
    }

    public void doProgressiveRestoreLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressiveLog(req, rsp, this.getRestoreLogFile());
    }

    private void doProgressiveLog(StaplerRequest req, StaplerResponse rsp, File file) throws IOException {
        new LargeText(file, this.task.isFinished()).doProgressText(req, rsp);
    }

    public String getRootDirectory() {
        return Hudson.getInstance().getRootDir().getAbsolutePath();
    }

    private File getBackupLogFile() {
        return new File(Hudson.getInstance().getRootDir().getAbsolutePath(), "/backup.log");
    }

    private File getRestoreLogFile() {
        return new File(System.getProperty("java.io.tmpdir"), "/hudson_restore.log");
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ boolean access$102(BackupLink x0, boolean x1) {
        x0.fileNameOk = x1;
        return x0.fileNameOk;
    }
}

