/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils.compress;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.jvnet.hudson.plugins.backup.utils.compress.ArchiverException;
import org.jvnet.hudson.plugins.backup.utils.compress.UnArchiver;

public abstract class AbstractUnArchiver
implements UnArchiver {
    protected static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(AbstractUnArchiver.class.getName());

    public abstract org.codehaus.plexus.archiver.AbstractUnArchiver getUnArchiver();

    public void unArchive(File archive, String toDir) throws ArchiverException {
        org.codehaus.plexus.archiver.AbstractUnArchiver unarchiver = this.getUnArchiver();
        File destDir = new File(toDir);
        if (!destDir.exists()) {
            try {
                FileUtils.forceMkdir((File)destDir);
            }
            catch (IOException e) {
                String message = "Unable to created directory " + destDir.getAbsolutePath();
                LOGGER.severe(message);
                throw new ArchiverException(message, (Throwable)e);
            }
        }
        unarchiver.enableLogging((Logger)new ConsoleLogger(1, "UnArchiver"));
        unarchiver.setSourceFile(archive);
        unarchiver.setDestDirectory(destDir);
        try {
            unarchiver.extract();
        }
        catch (org.codehaus.plexus.archiver.ArchiverException e) {
            String message = "Unable to extract " + archive.getAbsolutePath() + " content to " + toDir;
            LOGGER.severe(message);
            throw new ArchiverException(message, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
        }
    }
}

