/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import hudson.model.Hudson;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.plugins.backup.utils.BackupLogger;
import org.jvnet.hudson.plugins.backup.utils.BackupPluginTask;
import org.jvnet.hudson.plugins.backup.utils.FakeObject;
import org.jvnet.hudson.plugins.backup.utils.compress.CompressionMethodEnum;
import org.jvnet.hudson.plugins.backup.utils.compress.UnArchiver;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RestoreTask
extends BackupPluginTask {
    private static final Logger LOGGER = Logger.getLogger(RestoreTask.class.getName());
    private ServletContext servletContext;

    public RestoreTask(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void run() {
        assert (this.logFileName != null);
        assert (this.fileName != null);
        this.startDate = new Date();
        try {
            this.logger = new BackupLogger(this.logFileName, this.verbose);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to open log file for writing : " + this.logFileName);
            return;
        }
        this.logger.info("Restore started at " + RestoreTask.getTimestamp(this.startDate));
        File directory = new File(this.configurationDirectory);
        String tempDirectoryPath = this.configurationDirectory + "_restore";
        this.logger.info("Working into " + tempDirectoryPath + " directory");
        File temporary_directory = new File(tempDirectoryPath);
        if (temporary_directory.exists()) {
            this.logger.info("A old restore working dir exists, cleaning ...");
            try {
                FileUtils.deleteDirectory((File)temporary_directory);
            }
            catch (IOException e) {
                this.logger.error("Unable to delete " + tempDirectoryPath);
                e.printStackTrace(this.logger.getWriter());
                return;
            }
        }
        temporary_directory.mkdir();
        File archive = new File(this.fileName);
        this.logger.info("Uncompressing archive file...");
        UnArchiver unAchiver = CompressionMethodEnum.ZIP.getUnArchiver();
        try {
            unAchiver.unArchive(archive, tempDirectoryPath);
        }
        catch (Exception e) {
            this.logger.error("Error uncompressiong archive.");
            this.logger.error("Look to hudson global logs for more informations.");
        }
        this.logger.info("Removing old configuration files...");
        this.delete(directory);
        this.logger.info("Making temporary directory the hudson home...");
        temporary_directory.renameTo(directory);
        this.logger.info("*****************************************");
        this.logger.info("Reloading hudson configuration from disk.");
        this.logger.info("*****************************************");
        StaplerRequest request = FakeObject.getStaplerRequestFake(this.servletContext);
        StaplerResponse response = FakeObject.getStaplerResponseFake();
        try {
            Hudson.getInstance().doReload(request, response);
        }
        catch (IOException e) {
            this.logger.error("Error reloading config files from disk.");
            this.logger.error("Call this method manually");
            e.printStackTrace(this.logger.getWriter());
        }
        this.endDate = new Date();
        this.logger.info("Backup end at " + RestoreTask.getTimestamp(this.endDate));
        BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
        delay = delay.setScale(2, 4);
        delay = delay.divide(new BigDecimal("1000"));
        this.logger.info("[" + delay.toPlainString() + "s]");
        this.finished = true;
        this.logger.close();
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.delete(files[i]);
            }
        }
        if (this.verbose) {
            this.logger.debug("Deleting " + file.getAbsolutePath());
        }
        file.delete();
    }
}

