/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils.compress;

import org.jvnet.hudson.plugins.backup.utils.compress.Archiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarGzipArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarGzipUnArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.UnArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.ZipArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.ZipUnArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CompressionMethodEnum {
    ZIP("ZIP", ZipArchiver.class, ZipUnArchiver.class),
    TARGZIP("tgz", TarGzipArchiver.class, TarGzipUnArchiver.class);

    private final String code;
    private final Class<? extends Archiver> archiverClass;
    private final Class<? extends UnArchiver> unArchiverClass;

    private CompressionMethodEnum(String code, Class<? extends Archiver> archiverClass, Class<? extends UnArchiver> unArchiverClass) {
        this.code = code;
        this.archiverClass = archiverClass;
        this.unArchiverClass = unArchiverClass;
    }

    public String getCode() {
        return this.code;
    }

    public Archiver getArchiver() {
        try {
            return this.archiverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
    }

    public static Archiver getArchiver(CompressionMethodEnum method) {
        return method.getArchiver();
    }

    public UnArchiver getUnArchiver() {
        try {
            return this.unArchiverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
    }

    public static UnArchiver getUnArchiver(CompressionMethodEnum method) {
        return method.getUnArchiver();
    }
}

