/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.security.ACL;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.jvnet.hudson.plugins.backup.BackupConfig;
import org.jvnet.hudson.plugins.backup.BackupException;
import org.jvnet.hudson.plugins.backup.utils.BackupEngine;
import org.jvnet.hudson.plugins.backup.utils.BackupLogger;
import org.jvnet.hudson.plugins.backup.utils.BackupPluginTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BackupTask
extends BackupPluginTask {
    private static final Integer DELAY = 5000;
    private List<String> exclusions = new ArrayList();

    public BackupTask(BackupConfig configuration, String hudsonWorkDir, String backupFileName, String logFilePath) {
        super(configuration, hudsonWorkDir, backupFileName, logFilePath);
        this.exclusions.addAll(this.getDefaultExclusions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        assert (this.logFilePath != null);
        assert (this.configuration.getFileNameTemplate() != null);
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        this.startDate = new Date();
        try {
            this.logger = new BackupLogger(this.logFilePath, this.configuration.isVerbose());
        }
        catch (IOException e) {
            LOGGER.severe("Unable to open log file for writing : " + this.logFilePath);
            return;
        }
        this.logger.info("Backup started at " + BackupTask.getTimestamp((Date)this.startDate));
        this.waitNoJobsInQueue();
        FileFilter filter = this.createFileFilter(this.exclusions);
        try {
            try {
                BackupEngine backupEngine = new BackupEngine(this.logger, this.hudsonWorkDir, this.backupFileName, this.configuration.getArchiveType().getArchiver(), filter);
                backupEngine.doBackup();
            }
            catch (BackupException e) {
                e.printStackTrace(this.logger.getWriter());
                Object var4_6 = null;
                this.cancelNoJobs();
                this.endDate = new Date();
                this.logger.info("Backup end at " + BackupTask.getTimestamp((Date)this.endDate));
                BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
                delay = delay.setScale(2, 4);
                delay = delay.divide(new BigDecimal("1000"));
                this.logger.info("[" + delay.toPlainString() + "s]");
                this.finished = true;
                this.logger.close();
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.cancelNoJobs();
            this.endDate = new Date();
            this.logger.info("Backup end at " + BackupTask.getTimestamp((Date)this.endDate));
            BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
            delay = delay.setScale(2, 4);
            delay = delay.divide(new BigDecimal("1000"));
            this.logger.info("[" + delay.toPlainString() + "s]");
            this.finished = true;
            this.logger.close();
            throw throwable;
        }
        this.cancelNoJobs();
        this.endDate = new Date();
        this.logger.info("Backup end at " + BackupTask.getTimestamp((Date)this.endDate));
        BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
        delay = delay.setScale(2, 4);
        delay = delay.divide(new BigDecimal("1000"));
        this.logger.info("[" + delay.toPlainString() + "s]");
        this.finished = true;
        this.logger.close();
    }

    public List<String> getDefaultExclusions() {
        ArrayList<String> defaultExclusion = new ArrayList<String>();
        defaultExclusion.add("workspace");
        defaultExclusion.add("backup.log");
        return defaultExclusion;
    }

    private FileFilter createFileFilter(List<String> exclusions) {
        NameFileFilter filter = new NameFileFilter(exclusions.toArray(new String[0]));
        filter = new NotFileFilter((IOFileFilter)filter);
        return filter;
    }

    private void waitNoJobsInQueue() {
        this.logger.info("Setting hudson in shutdown mode to avoid files corruptions.");
        try {
            Hudson.getInstance().doQuietDown();
        }
        catch (Exception e) {
            this.logger.error("Erreur putting hudson in shutdown mode.");
            e.printStackTrace(this.logger.getWriter());
        }
        this.logger.info("Waiting all jobs end...");
        Computer[] computer = Hudson.getInstance().getComputers();
        int running = 1;
        while (running > 0) {
            running = 0;
            for (int i = 0; i < computer.length; ++i) {
                running += computer[i].countBusy();
            }
            this.logger.info("Number of running jobs detected : " + running);
            try {
                Thread.sleep(DELAY.intValue());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.info("All jobs finished.");
    }

    private void cancelNoJobs() {
        this.logger.info("Cancel hudson shutdown mode");
        try {
            Hudson.getInstance().doCancelQuietDown();
        }
        catch (Exception e) {
            this.logger.error("Erreur cancelling hudson shutdown mode.");
            e.printStackTrace(this.logger.getWriter());
        }
    }
}

