/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.DirectoryWalker;
import org.jvnet.hudson.plugins.backup.BackupException;
import org.jvnet.hudson.plugins.backup.utils.BackupLogger;
import org.jvnet.hudson.plugins.backup.utils.compress.Archiver;
import org.jvnet.hudson.plugins.backup.utils.compress.ArchiverException;

public class BackupEngine
extends DirectoryWalker {
    private BackupLogger logger;
    private File source;
    private int nbFiles = 0;
    private int nbErrors = 0;
    private int sourceLength;
    private Archiver archiver;

    public BackupEngine(BackupLogger logger, String sourceDirectory, String targetName, Archiver archiver, FileFilter filter) throws BackupException {
        super(filter, -1);
        this.logger = logger;
        this.source = new File(sourceDirectory);
        this.sourceLength = sourceDirectory.length();
        File targetFile = new File(targetName);
        logger.info("Full backup file name : " + targetFile.getAbsolutePath());
        this.archiver = archiver;
        try {
            archiver.init(targetFile);
        }
        catch (ArchiverException e) {
            throw new BackupException(e);
        }
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        if (!file.exists()) {
            this.logger.warn("inconsistent file " + file.getAbsolutePath());
            ++this.nbErrors;
            super.handleFile(file, depth, results);
            return;
        }
        String name = this.getInArchiveName(file.getAbsolutePath());
        this.logger.debug(name + " file");
        try {
            this.archiver.addFile(name, file);
        }
        catch (ArchiverException e) {
            this.logger.error(e.getMessage());
            throw new IOException("Unable to add " + name);
        }
        ++this.nbFiles;
        super.handleFile(file, depth, results);
    }

    protected void handleEnd(Collection results) throws IOException {
        try {
            this.archiver.close();
        }
        catch (ArchiverException e) {
            this.logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        this.logger.info("Saved files : " + this.nbFiles);
        this.logger.info("Number of errors : " + this.nbErrors);
    }

    public void doBackup() throws BackupException {
        try {
            this.walk(this.source, new ArrayList());
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    private String getInArchiveName(String absoluteName) {
        return absoluteName.substring(this.sourceLength + 1);
    }
}

