/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup;

import hudson.Plugin;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.backup.BackupConfig;
import org.jvnet.hudson.plugins.backup.BackupLink;
import org.jvnet.hudson.plugins.backup.utils.BackupPersistence;

public class BackupPluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(BackupLink.class.getName());
    private BackupConfig configuration;
    private static BackupPluginImpl instance;

    public BackupPluginImpl() {
        instance = this;
    }

    public static BackupPluginImpl getInstance() {
        return instance;
    }

    public void start() {
        ManagementLink.LIST.add(BackupLink.getInstance());
        try {
            this.configuration = this.loadConfiguration();
        }
        catch (IOException e) {
            LOGGER.severe("Error loading configuration file : " + e.getMessage());
        }
    }

    public BackupConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BackupConfig configuration) {
        this.configuration = configuration;
        try {
            this.saveConfiguration(configuration);
        }
        catch (IOException e) {
            LOGGER.severe("Error saving configuration file : " + e.getMessage());
        }
    }

    private BackupConfig loadConfiguration() throws IOException {
        LOGGER.info("Loading configuration...");
        BackupPersistence persistence = new BackupPersistence();
        BackupConfig config = persistence.loadConfig();
        return config;
    }

    private void saveConfiguration(BackupConfig configuration) throws IOException {
        LOGGER.info("Saving configuration...");
        BackupPersistence persistence = new BackupPersistence();
        persistence.saveConfig(configuration);
    }
}

