/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import java.io.IOException;
import java.io.PrintWriter;

public class BackupLogger {
    private PrintWriter logFile;
    private boolean debug;

    public BackupLogger(String logFileName, boolean debug) throws IOException {
        this.logFile = new PrintWriter(logFileName);
        this.debug = debug;
    }

    public void debug(String message) {
        if (this.debug) {
            this.log("[DEBUG]", message);
        }
    }

    public void warn(String message) {
        this.log("[ WARN]", message);
        this.logFile.flush();
    }

    public void info(String message) {
        this.log("[ INFO]", message);
        this.logFile.flush();
    }

    public void error(String message) {
        this.log("[ERROR]", message);
        this.logFile.flush();
    }

    public PrintWriter getWriter() {
        return this.logFile;
    }

    public void close() {
        this.logFile.flush();
        this.logFile.close();
    }

    private void log(String level, String message) {
        this.logFile.println(level + " " + message);
    }
}

