/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils.compress;

import org.jvnet.hudson.plugins.backup.utils.compress.Archiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarBz2Archiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarBz2UnArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarGzipArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.TarGzipUnArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.UnArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.ZipArchiver;
import org.jvnet.hudson.plugins.backup.utils.compress.ZipUnArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public enum CompressionMethodEnum {
    ZIP("zip", ZipArchiver.class, ZipUnArchiver.class),
    TARGZIP("tar.gz", TarGzipArchiver.class, TarGzipUnArchiver.class),
    TARBZ2("tar.bz2", TarBz2Archiver.class, TarBz2UnArchiver.class);

    private final String code;
    private final Class<? extends Archiver> archiverClass;
    private final Class<? extends UnArchiver> unArchiverClass;

    private CompressionMethodEnum(String code, Class<? extends Archiver> archiverClass, Class<? extends UnArchiver> unArchiverClass) {
        this.code = code;
        this.archiverClass = archiverClass;
        this.unArchiverClass = unArchiverClass;
    }

    public String getCode() {
        return this.code;
    }

    public Archiver getArchiver() {
        try {
            return (Archiver)this.archiverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
    }

    public static Archiver getArchiver(CompressionMethodEnum method) {
        return method.getArchiver();
    }

    public UnArchiver getUnArchiver() {
        try {
            return (UnArchiver)this.unArchiverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instanciate compression engine for " + this.getCode() + " method.", e);
        }
    }

    public static UnArchiver getUnArchiver(CompressionMethodEnum method) {
        return method.getUnArchiver();
    }

    public static CompressionMethodEnum getFromCode(String code) {
        for (CompressionMethodEnum value : CompressionMethodEnum.values()) {
            if (!value.code.equals(code)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown code " + code);
    }
}

