/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.backup.utils.compress.CompressionMethodEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupConfig {
    private static final String DEFAULT_FILE_NAME_TEMPLATE = "backup_@date@.@extension@";
    private static final CompressionMethodEnum DEFAULT_COMPRESSION_METHOD = CompressionMethodEnum.ZIP;
    private String targetDirectory;
    private boolean verbose;
    private String fileNameTemplate = "backup_@date@.@extension@";
    private CompressionMethodEnum archiveType = CompressionMethodEnum.TARGZIP;
    private boolean keepWorkspaces;
    private boolean keepFingerprints;
    private boolean keepBuilds;
    private boolean keepArchives;
    private String jobIncludes;
    private String jobExcludes;
    private boolean caseSensitive;
    private List<String> customExclusions = new ArrayList();

    public List<String> getCustomExclusions() {
        return this.customExclusions;
    }

    public void setCustomExclusions(List<String> exclusions) {
        this.customExclusions.clear();
        this.customExclusions.addAll(exclusions);
    }

    public void addExclusion(String exclusion) {
        this.customExclusions.add(exclusion);
    }

    public String getCustomExclusionsString() {
        return StringUtils.join((Collection)this.customExclusions, (char)',');
    }

    public void setCustomExclusionsString(String customExclusionsString) {
        String[] exclusionsArray = StringUtils.split((String)customExclusionsString, (String)", ");
        List<String> exclusionsList = Arrays.asList(exclusionsArray);
        this.setCustomExclusions(exclusionsList);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getFileNameTemplate() {
        if (StringUtils.isNotEmpty((String)this.fileNameTemplate)) {
            return this.fileNameTemplate;
        }
        return DEFAULT_FILE_NAME_TEMPLATE;
    }

    public void setFileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
    }

    public CompressionMethodEnum getArchiveType() {
        if (this.archiveType != null) {
            return this.archiveType;
        }
        return DEFAULT_COMPRESSION_METHOD;
    }

    public void setArchiveType(CompressionMethodEnum archiveType) {
        this.archiveType = archiveType;
    }

    public void setKeepWorkspaces(boolean keeping) {
        this.keepWorkspaces = keeping;
    }

    public boolean getKeepWorkspaces() {
        return this.keepWorkspaces;
    }

    public void setKeepFingerprints(boolean keepFingerprints) {
        this.keepFingerprints = keepFingerprints;
    }

    public boolean getKeepFingerprints() {
        return this.keepFingerprints;
    }

    public void setKeepBuilds(boolean keepBuilds) {
        this.keepBuilds = keepBuilds;
    }

    public boolean getKeepBuilds() {
        return this.keepBuilds;
    }

    public void setKeepArchives(boolean keepArchives) {
        this.keepArchives = keepArchives;
    }

    public boolean getKeepArchives() {
        return this.keepArchives;
    }

    public String getJobIncludes() {
        return this.jobIncludes;
    }

    public void setJobIncludes(String jobIncludes) {
        this.jobIncludes = jobIncludes;
    }

    public String getJobExcludes() {
        return this.jobExcludes;
    }

    public void setJobExcludes(String jobExcludes) {
        this.jobExcludes = jobExcludes;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

