/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup;

import hudson.model.Hudson;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.backup.BackupConfig;
import org.jvnet.hudson.plugins.backup.BackupPluginImpl;
import org.jvnet.hudson.plugins.backup.Messages;
import org.jvnet.hudson.plugins.backup.utils.BackupPluginTask;
import org.jvnet.hudson.plugins.backup.utils.BackupTask;
import org.jvnet.hudson.plugins.backup.utils.LastModifiedFileComparator;
import org.jvnet.hudson.plugins.backup.utils.RestoreTask;
import org.jvnet.hudson.plugins.backup.utils.compress.CompressionMethodEnum;
import org.jvnet.hudson.plugins.backup.utils.filename.FileNameManager;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(BackupLink.class.getName());
    private BackupPluginTask task;
    private Boolean backupRunning = Boolean.FALSE;

    public BackupConfig getConfiguration() {
        return BackupPluginImpl.getInstance().getConfiguration();
    }

    public String getIconFileName() {
        return "/plugin/backup/images/backup-48x48.png";
    }

    public String getUrlName() {
        return "backup";
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (CompressionMethodEnum method : CompressionMethodEnum.values()) {
            if (!method.isSupportedByPlatform()) continue;
            extensions.add(method.getCode());
        }
        return extensions;
    }

    public void doLaunchBackup(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        if (this.task != null && !this.task.isFinished()) {
            rsp.sendRedirect("backup");
            return;
        }
        BackupConfig configuration = this.getConfiguration();
        String fileNameTemplate = configuration.getTargetDirectory() + File.separator + configuration.getFileNameTemplate();
        String fileName = new FileNameManager().getFileName(fileNameTemplate, configuration);
        LOGGER.info("backup file name = " + fileName + " (generated from template :" + fileNameTemplate + ")");
        this.task = new BackupTask(configuration, this.getRootDirectory(), fileName, this.getBackupLogFile().getAbsolutePath());
        Thread thread = Executors.defaultThreadFactory().newThread((Runnable)this.task);
        thread.start();
        rsp.sendRedirect("backup");
    }

    public void doRestoreFile(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="file") String backupFile) throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        BackupConfig configuration = this.getConfiguration();
        String path = configuration.getTargetDirectory();
        String filePath = path + File.separator + backupFile;
        LOGGER.log(Level.INFO, "Selected file : {0}", backupFile);
        this.task = new RestoreTask(configuration, Hudson.getInstance().getRootDir().getAbsolutePath(), filePath, this.getRestoreLogFile().getAbsolutePath(), res.getServletContext());
        Thread thread = Executors.defaultThreadFactory().newThread((Runnable)this.task);
        thread.start();
        rsp.sendRedirect("restore");
    }

    public List<File> getFileList() throws IOException {
        LOGGER.log(Level.INFO, "Listing files of {0}", this.getConfiguration().getTargetDirectory());
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        BackupConfig configuration = this.getConfiguration();
        File backupDirectory = new File(configuration.getTargetDirectory());
        File[] backupFiles = backupDirectory.listFiles();
        List<File> fileList = backupFiles == null ? new ArrayList<File>() : Arrays.asList(backupFiles);
        Collections.sort(fileList, new LastModifiedFileComparator());
        return fileList;
    }

    public void doSaveSettings(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="backupDirectoryPath") String backupPath, @QueryParameter(value="archive_format") String format, @QueryParameter(value="customExclusionsString") String customExclusionsString, @QueryParameter(value="verbose") boolean verbose, @QueryParameter(value="fileNameTemplate") String fileNameTemplate, @QueryParameter(value="keepWorkspaces") boolean keepWorkspaces, @QueryParameter(value="keepFingerprints") boolean keepFingerprints, @QueryParameter(value="keepBuilds") boolean keepBuilds, @QueryParameter(value="keepArchives") boolean keepArchives, @QueryParameter(value="jobIncludes") String jobIncludes, @QueryParameter(value="jobExcludes") String jobExcludes, @QueryParameter(value="caseSensitive") boolean caseSensitive) throws IOException {
        LOGGER.info("BackupLink.doSaveSetting");
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        BackupConfig configuration = new BackupConfig();
        configuration.setTargetDirectory(backupPath);
        configuration.setVerbose(verbose);
        configuration.setFileNameTemplate(fileNameTemplate);
        CompressionMethodEnum archiveType = CompressionMethodEnum.getFromCode((String)format);
        configuration.setArchiveType(archiveType);
        configuration.setCustomExclusionsString(customExclusionsString);
        configuration.setKeepWorkspaces(keepWorkspaces);
        configuration.setKeepFingerprints(keepFingerprints);
        configuration.setKeepBuilds(keepBuilds);
        configuration.setKeepArchives(keepArchives);
        configuration.setJobIncludes(jobIncludes);
        configuration.setJobExcludes(jobExcludes);
        configuration.setCaseSensitive(caseSensitive);
        BackupPluginImpl.getInstance().setConfiguration(configuration);
        LOGGER.info("Backup configuration saved.");
        rsp.sendRedirect(res.getContextPath() + "/backup");
    }

    public void doProgressiveBackupLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressiveLog(req, rsp, this.getBackupLogFile());
    }

    public void doProgressiveRestoreLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressiveLog(req, rsp, this.getRestoreLogFile());
    }

    private void doProgressiveLog(StaplerRequest req, StaplerResponse rsp, File file) throws IOException {
        boolean backupFinished = this.task.isFinished();
        new LargeText(file, backupFinished).doProgressText(req, rsp);
        if (backupFinished) {
            this.task = null;
        }
    }

    public String getRootDirectory() {
        return Hudson.getInstance().getRootDir().getAbsolutePath();
    }

    private File getBackupLogFile() {
        return new File(Hudson.getInstance().getRootDir().getAbsolutePath(), "/backup.log");
    }

    private File getRestoreLogFile() {
        return new File(System.getProperty("java.io.tmpdir"), "/hudson_restore.log");
    }
}

