/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import hudson.XmlFile;
import hudson.model.Hudson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.backup.BackupConfig;

public class BackupPersistence {
    protected static final Logger LOGGER = Logger.getLogger(BackupPersistence.class.getName());
    private static final String CONFIG_FILE = "backup.xml";

    public void saveConfig(BackupConfig config) throws IOException {
        XmlFile xmlFile = this.getConfigFile();
        xmlFile.write((Object)config);
    }

    public BackupConfig loadConfig() throws IOException {
        BackupConfig config;
        XmlFile xmlFile = this.getConfigFile();
        try {
            config = (BackupConfig)xmlFile.read();
        }
        catch (FileNotFoundException e) {
            LOGGER.info("Config file not found.");
            config = new BackupConfig();
        }
        return config;
    }

    private XmlFile getConfigFile() {
        XmlFile xmlFile = new XmlFile(new File(Hudson.getInstance().getRootDir(), CONFIG_FILE));
        return xmlFile;
    }
}

