/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import java.util.Date;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.backup.BackupConfig;
import org.jvnet.hudson.plugins.backup.utils.BackupLogger;
import org.jvnet.hudson.plugins.backup.utils.BackupTask;

public abstract class BackupPluginTask
implements Runnable {
    protected static final Logger LOGGER = Logger.getLogger(BackupTask.class.getName());
    protected String logFilePath;
    protected String hudsonWorkDir;
    protected String backupFileName;
    protected BackupLogger logger;
    protected Date startDate;
    protected Date endDate;
    protected boolean finished = false;
    protected BackupConfig configuration;

    protected BackupPluginTask(BackupConfig configuration, String hudsonWorkDir, String backupFileName, String logFilePath) {
        this.configuration = configuration;
        this.setHudsonWorkDir(hudsonWorkDir);
        this.setLogFilePath(logFilePath);
        this.setBackupFileName(backupFileName);
    }

    public abstract void run();

    private void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    private void setHudsonWorkDir(String hudsonWorkDir) {
        this.hudsonWorkDir = hudsonWorkDir;
    }

    private void setBackupFileName(String backupFileName) {
        this.backupFileName = backupFileName;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected static String getTimestamp(Date date) {
        return String.format("[%1$tD %1$tT]", date);
    }
}

