/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.security.ACL;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jvnet.hudson.plugins.backup.BackupConfig;
import org.jvnet.hudson.plugins.backup.BackupException;
import org.jvnet.hudson.plugins.backup.utils.BackupEngine;
import org.jvnet.hudson.plugins.backup.utils.BackupLogger;
import org.jvnet.hudson.plugins.backup.utils.BackupPluginTask;
import org.jvnet.hudson.plugins.backup.utils.filename.SimpleFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupTask
extends BackupPluginTask {
    public static final String JOBS_NAME = "jobs";
    public static final String WORKSPACE_NAME = "workspace";
    public static final String FINGERPRINTS_NAME = "fingerprints";
    public static final String BUILDS_NAME = "builds";
    public static final String ARCHIVE_NAME = "archive";
    public static final String[] DEFAULT_EXCLUSIONS = new String[]{"backup.log"};
    private static final Integer DELAY = 5000;

    public BackupTask(BackupConfig configuration, String hudsonWorkDir, String backupFileName, String logFilePath) {
        super(configuration, hudsonWorkDir, backupFileName, logFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (this.logFilePath != null);
        assert (this.configuration.getFileNameTemplate() != null);
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        this.startDate = new Date();
        try {
            this.logger = new BackupLogger(this.logFilePath, this.configuration.isVerbose());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to open log file for writing: {0}", this.logFilePath);
            return;
        }
        this.logger.info("Backup started at " + BackupTask.getTimestamp(this.startDate));
        if (!this.configuration.isNoShutdown()) {
            this.waitNoJobsInQueue();
        }
        IOFileFilter jobsExclusionFileFilter = null;
        ArrayList<String> exclusions = new ArrayList<String>();
        exclusions.addAll(Arrays.asList(DEFAULT_EXCLUSIONS));
        exclusions.addAll(this.configuration.getCustomExclusions());
        if (!this.configuration.getKeepWorkspaces()) {
            exclusions.add(WORKSPACE_NAME);
        } else {
            jobsExclusionFileFilter = BackupTask.createJobsExclusionFileFilter(this.hudsonWorkDir, this.configuration.getJobIncludes(), this.configuration.getJobExcludes(), this.configuration.getCaseSensitive());
        }
        if (!this.configuration.getKeepFingerprints()) {
            exclusions.add(FINGERPRINTS_NAME);
        }
        if (!this.configuration.getKeepBuilds()) {
            exclusions.add(BUILDS_NAME);
        }
        if (!this.configuration.getKeepArchives()) {
            exclusions.add(ARCHIVE_NAME);
        }
        IOFileFilter filter = BackupTask.createFileFilter(exclusions, jobsExclusionFileFilter);
        if (this.configuration.isXmlOnly()) {
            filter = FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".xml"), (IOFileFilter)FileFilterUtils.directoryFileFilter()));
        }
        try {
            try {
                BackupEngine backupEngine = new BackupEngine(this.logger, this.hudsonWorkDir, this.backupFileName, this.configuration.getArchiveType().getArchiver(), filter);
                backupEngine.doBackup();
            }
            catch (BackupException e) {
                e.printStackTrace(this.logger.getWriter());
                Object var6_8 = null;
                this.cancelNoJobs();
                this.endDate = new Date();
                this.logger.info("Backup end at " + BackupTask.getTimestamp(this.endDate));
                BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
                delay = delay.setScale(2, 4);
                delay = delay.divide(new BigDecimal("1000"));
                this.logger.info("[" + delay.toPlainString() + "s]");
                this.finished = true;
                this.logger.close();
            }
            Object var6_7 = null;
            this.cancelNoJobs();
            this.endDate = new Date();
            this.logger.info("Backup end at " + BackupTask.getTimestamp(this.endDate));
            BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
            delay = delay.setScale(2, 4);
            delay = delay.divide(new BigDecimal("1000"));
            this.logger.info("[" + delay.toPlainString() + "s]");
            this.finished = true;
            this.logger.close();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.cancelNoJobs();
            this.endDate = new Date();
            this.logger.info("Backup end at " + BackupTask.getTimestamp(this.endDate));
            BigDecimal delay = new BigDecimal(this.endDate.getTime() - this.startDate.getTime());
            delay = delay.setScale(2, 4);
            delay = delay.divide(new BigDecimal("1000"));
            this.logger.info("[" + delay.toPlainString() + "s]");
            this.finished = true;
            this.logger.close();
            throw throwable;
        }
    }

    public static IOFileFilter createFileFilter(List<String> exclusions, IOFileFilter jobsExclusionFileFilter) {
        if (jobsExclusionFileFilter == null) {
            return FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter(exclusions.toArray(new String[0])));
        }
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter(exclusions.toArray(new String[0]))), (IOFileFilter)jobsExclusionFileFilter);
    }

    public static IOFileFilter createJobsExclusionFileFilter(String hudsonWorkDir, String jobIncludes, String jobExcludes, boolean caseSensitive) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(new File(hudsonWorkDir, JOBS_NAME));
        directoryScanner.setCaseSensitive(caseSensitive);
        if (jobIncludes != null && jobIncludes.length() > 0) {
            jobIncludes = jobIncludes.replaceAll(Matcher.quoteReplacement("\\"), "/");
            jobIncludes = "*/workspace/" + jobIncludes;
            jobIncludes = jobIncludes.replaceAll(",", ",*/workspace/");
            directoryScanner.setIncludes(jobIncludes.split(","));
        } else {
            directoryScanner.setIncludes(null);
        }
        if (jobExcludes != null && jobExcludes.length() > 0) {
            jobExcludes = jobExcludes.replaceAll(Matcher.quoteReplacement("\\"), "/");
            jobExcludes = "*/workspace/" + jobExcludes;
            jobExcludes = jobExcludes.replaceAll(",", ",*/workspace/");
            directoryScanner.setExcludes(jobExcludes.split(","));
        } else {
            directoryScanner.setExcludes(null);
        }
        directoryScanner.scan();
        SimpleFileFilter ff = new SimpleFileFilter(directoryScanner.getBasedir(), directoryScanner.getExcludedDirectories(), directoryScanner.getExcludedFiles());
        return FileFilterUtils.notFileFilter((IOFileFilter)new DelegateFileFilter((FileFilter)ff));
    }

    private void waitNoJobsInQueue() {
        this.logger.info("Setting hudson in shutdown mode to avoid files corruptions.");
        try {
            Hudson.getInstance().doQuietDown();
        }
        catch (NoSuchMethodError e) {
        }
        catch (Exception e) {
            this.logger.error("Erreur putting hudson in shutdown mode.");
            e.printStackTrace(this.logger.getWriter());
        }
        this.logger.info("Waiting all jobs end...");
        Computer[] computer = Hudson.getInstance().getComputers();
        int running = 1;
        while (running > 0) {
            running = 0;
            for (int i = 0; i < computer.length; ++i) {
                running += computer[i].countBusy();
            }
            this.logger.info("Number of running jobs detected : " + running);
            try {
                Thread.sleep(DELAY.intValue());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.info("All jobs finished.");
    }

    private void cancelNoJobs() {
        this.logger.info("Cancel hudson shutdown mode");
        try {
            Hudson.getInstance().doCancelQuietDown();
        }
        catch (NoSuchMethodError e) {
        }
        catch (Exception e) {
            this.logger.error("Erreur cancelling hudson shutdown mode.");
            e.printStackTrace(this.logger.getWriter());
        }
    }
}

