/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.backup.utils.filename;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jvnet.hudson.plugins.backup.BackupConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileNamePatternEnum {
    DATE("date"){
        final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmm");

        public String replace(String template, BackupConfig configuration) {
            String date = this.formatter.format(new Date());
            return template.replace(FileNamePatternEnum.getFullPattern(this.pattern), date);
        }
    }
    ,
    EXTENSION("extension"){

        public String replace(String template, BackupConfig configuration) {
            return template.replace(FileNamePatternEnum.getFullPattern(this.pattern), configuration.getArchiveType().getCode());
        }
    };

    private static final String SEPARATOR = "@";
    String pattern;

    private FileNamePatternEnum(String pattern) {
        this.pattern = pattern;
    }

    public boolean isPresentIn(String template) {
        return template.contains(SEPARATOR + this.pattern + SEPARATOR);
    }

    public abstract String replace(String var1, BackupConfig var2);

    private static String getFullPattern(String pattern) {
        return SEPARATOR + pattern + SEPARATOR;
    }
}

