/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.batch_task.BatchRun;
import hudson.plugins.batch_task.BatchTask;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRunAction
implements Action {
    public final AbstractBuild<?, ?> owner;
    protected final List<BatchRun> records = new LinkedList();

    public BatchRunAction(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    public String getIconFileName() {
        return "gear2.gif";
    }

    public String getDisplayName() {
        return "Executed Tasks";
    }

    public String getUrlName() {
        return "batchTasks";
    }

    protected BatchRun createRecord(BatchTask task) throws IOException {
        BatchRun r = new BatchRun((Calendar)new GregorianCalendar(), this, this.records.size(), task);
        this.records.add(0, r);
        this.owner.save();
        return r;
    }

    public List<BatchRun> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public BatchRun getRecord(int id) {
        int idx = this.records.size() - id - 1;
        if (idx >= 0) {
            BatchRun r = (BatchRun)this.records.get(idx);
            if (r.id == id) {
                return r;
            }
        }
        for (int i = 0; i < id; ++i) {
            BatchRun r = (BatchRun)this.records.get(i);
            if (r.id != id) continue;
            return r;
        }
        return null;
    }

    private Object readResolve() {
        for (BatchRun r : this.records) {
            r.parent = this;
        }
        Collections.sort(this.records);
        return this;
    }

    public BatchRun getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getRecord(Integer.parseInt(token));
    }
}

