/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractBuild;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Result;
import hudson.plugins.batch_task.BatchRun;
import hudson.plugins.batch_task.BatchRunAction;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.widgets.BuildHistoryWidget;
import hudson.widgets.HistoryWidget;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchTask
extends AbstractModelObject
implements Queue.Task {
    public final String name;
    public final String script;
    transient AbstractProject<?, ?> owner;
    transient BatchTaskProperty parent;
    private static final HistoryWidget.Adapter<BatchRun> ADAPTER = new /* Unavailable Anonymous Inner Class!! */;
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("(\\d+)-(\\d+)");

    @DataBoundConstructor
    public BatchTask(String name, String script) {
        this.name = name;
        this.script = script;
    }

    public BatchTaskProperty getParent() {
        return this.parent;
    }

    public String getSearchUrl() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getFullDisplayName() {
        return this.owner.getFullDisplayName() + " \u00bb " + this.name;
    }

    public boolean isBuildBlocked() {
        return this.owner.isBuildBlocked();
    }

    public String getWhyBlocked() {
        return this.owner.getWhyBlocked();
    }

    public String getName() {
        return this.name;
    }

    public long getEstimatedDuration() {
        BatchRun b = this.getLastSuccessfulRun();
        if (b == null) {
            return -1L;
        }
        long duration = b.getDuration();
        if (duration == 0L) {
            return -1L;
        }
        return duration;
    }

    public Label getAssignedLabel() {
        return this.owner.getLastBuiltOn().getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return this.owner.getLastBuiltOn();
    }

    public String getBuildStatusUrl() {
        return this.getIconColor() + ".gif";
    }

    public BallColor getIconColor() {
        BatchRun r = this.getLastRun();
        if (r == null) {
            return BallColor.GREY;
        }
        return r.getIconColor();
    }

    public BatchRun getLastRun() {
        for (AbstractBuild b : this.owner.getBuilds()) {
            BatchRunAction bra = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (bra == null) continue;
            for (int i = bra.records.size() - 1; i >= 0; --i) {
                BatchRun br = (BatchRun)bra.records.get(i);
                if (!br.taskName.equals(this.name)) continue;
                return br;
            }
        }
        return null;
    }

    public BatchRun getLastSuccessfulRun() {
        for (BatchRun r = this.getLastRun(); r != null; r = r.getPrevious()) {
            if (r.getResult() != Result.SUCCESS) continue;
            return r;
        }
        return null;
    }

    public BatchRun getLastFailedRun() {
        for (BatchRun r = this.getLastRun(); r != null; r = r.getPrevious()) {
            if (r.getResult() != Result.FAILURE) continue;
            return r;
        }
        return null;
    }

    public Iterable<BatchRun> getRuns() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public HistoryWidget createHistoryWidget() {
        return new BuildHistoryWidget((Queue.Task)this, this.getRuns(), ADAPTER);
    }

    public Queue.Executable createExecutable() throws IOException {
        AbstractBuild lb = (AbstractBuild)this.owner.getLastBuild();
        BatchRunAction records = (BatchRunAction)lb.getAction(BatchRunAction.class);
        if (records == null) {
            records = new BatchRunAction(lb);
            lb.addAction((Action)records);
        }
        return records.createRecord(this);
    }

    public String getNextBuildNumber() {
        AbstractBuild lb = (AbstractBuild)this.owner.getLastBuild();
        if (lb == null) {
            return "0-0";
        }
        int id = 0;
        BatchRunAction records = (BatchRunAction)lb.getAction(BatchRunAction.class);
        if (records != null) {
            id = records.getRecords().size();
        }
        return lb.getNumber() + "-" + id;
    }

    public ResourceList getResourceList() {
        return new ResourceList().w(this.owner.getWorkspaceResource());
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Matcher m = BUILD_NUMBER_PATTERN.matcher(token);
        if (m.matches()) {
            AbstractBuild b = (AbstractBuild)this.owner.getBuildByNumber(Integer.parseInt(m.group(1)));
            if (b == null) {
                return null;
            }
            BatchRunAction a = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (a == null) {
                return null;
            }
            return a.getRecord(Integer.parseInt(m.group(2)));
        }
        return null;
    }

    public synchronized void doExecute(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!Hudson.adminCheck((StaplerRequest)req, (StaplerResponse)rsp)) {
            return;
        }
        Hudson.getInstance().getQueue().add((Queue.Task)this, 0);
        rsp.forwardToPreviousPage(req);
    }

    static /* synthetic */ Pattern access$000() {
        return BUILD_NUMBER_PATTERN;
    }
}

