/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final BatchTask[] tasks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BatchTaskProperty(BatchTask ... tasks) {
        this.tasks = tasks;
    }

    public BatchTaskProperty(Collection<BatchTask> tasks) {
        this(tasks.toArray(new BatchTask[tasks.size()]));
    }

    protected void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        for (BatchTask t : this.tasks) {
            t.owner = owner;
            t.parent = this;
        }
    }

    public List<BatchTask> getTasks() {
        return Collections.unmodifiableList(Arrays.asList(this.tasks));
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new BatchTaskAction(job, this.getTasks());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(BatchTaskProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Batch tasks";
        }

        public BatchTaskProperty newInstance(StaplerRequest req) throws Descriptor.FormException {
            if (req.getParameter("batch-tasks.on") != null) {
                return new BatchTaskProperty(req.bindParametersToList(BatchTask.class, "batch-task."));
            }
            return null;
        }
    }
}

