/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskAction;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.util.EditDistance;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskProperty
extends JobProperty<AbstractProject<?, ?>> {
    private final BatchTask[] tasks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BatchTaskProperty(BatchTask ... tasks) {
        this.tasks = tasks;
    }

    public BatchTaskProperty(Collection<BatchTask> tasks) {
        this(tasks.toArray(new BatchTask[tasks.size()]));
    }

    protected void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        for (BatchTask t : this.tasks) {
            t.owner = owner;
            t.parent = this;
        }
    }

    public BatchTask getTask(String name) {
        for (BatchTask t : this.tasks) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }

    public List<BatchTask> getTasks() {
        return Collections.unmodifiableList(Arrays.asList(this.tasks));
    }

    public BatchTask findNearestTask(String name) {
        String[] names = new String[this.tasks.length];
        for (int i = 0; i < this.tasks.length; ++i) {
            names[i] = this.tasks[i].name;
        }
        name = EditDistance.findNearest((String)name, (String[])names);
        return this.getTask(name);
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new BatchTaskAction(job, this.getTasks());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }
}

