/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.batch_task.BatchTaskInvoker;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskInvoker
extends Notifier {
    private final Config[] configs;
    private Result threshold;

    private Object readResolve() {
        if (this.threshold == null) {
            this.threshold = Result.UNSTABLE;
        }
        return this;
    }

    public BatchTaskInvoker(Config[] configs, Result threshold) {
        this.configs = configs;
        this.threshold = threshold;
    }

    public BatchTaskInvoker(JSONObject source) {
        ArrayList<Config> configList = new ArrayList<Config>();
        for (Object o : JSONArray.fromObject((Object)source.get("config"))) {
            configList.add(new Config((JSONObject)o));
        }
        this.configs = configList.toArray(new Config[configList.size()]);
        this.threshold = source.getBoolean("evenIfUnstable") ? Result.UNSTABLE : Result.SUCCESS;
    }

    public List<Config> getConfigs() {
        return Collections.unmodifiableList(Arrays.asList(this.configs));
    }

    public Result getThreshold() {
        return this.threshold;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        HashSet seenJobs = new HashSet();
        if (build.getResult().isBetterOrEqualTo(this.threshold)) {
            for (Config config : this.configs) {
                config.invoke(build, listener, seenJobs);
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }
}

