/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskAction;
import hudson.plugins.batch_task.Messages;
import hudson.util.EditDistance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskProperty
extends JobProperty<AbstractProject<?, ?>> {
    private volatile BatchTask[] tasks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BatchTaskProperty(BatchTask ... tasks) {
        this.tasks = tasks;
    }

    public BatchTaskProperty(Collection<BatchTask> tasks) {
        this(tasks.toArray(new BatchTask[tasks.size()]));
    }

    protected void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        for (BatchTask t : this.tasks) {
            t.owner = owner;
            t.parent = this;
        }
    }

    public AbstractProject<?, ?> getOwner() {
        return (AbstractProject)this.owner;
    }

    public BatchTask getTask(String name) {
        for (BatchTask t : this.tasks) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }

    public List<BatchTask> getTasks() {
        return Collections.unmodifiableList(Arrays.asList(this.tasks));
    }

    public synchronized void removeTask(BatchTask t) throws IOException {
        ArrayList<BatchTask> l = new ArrayList<BatchTask>(Arrays.asList(this.tasks));
        if (l.remove((Object)t)) {
            this.tasks = l.toArray(new BatchTask[l.size()]);
            this.getOwner().save();
        }
    }

    public BatchTask findNearestTask(String name) {
        String[] names = new String[this.tasks.length];
        for (int i = 0; i < this.tasks.length; ++i) {
            names[i] = this.tasks[i].name;
        }
        name = EditDistance.findNearest((String)name, (String[])names);
        return this.getTask(name);
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new BatchTaskAction(job, this);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(BatchTaskProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.BatchTaskProperty_DisplayName();
        }

        public BatchTaskProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req.getParameter("batch-tasks.on") != null) {
                return new BatchTaskProperty(req.bindParametersToList(BatchTask.class, "batch-task."));
            }
            return null;
        }
    }
}

