/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Environment;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.batch_task.BatchRun;
import hudson.plugins.batch_task.BatchRunAction;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskAction;
import hudson.slaves.NodeProperty;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BatchFile;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Shell;
import hudson.util.Iterators;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRun
extends Actionable
implements Queue.Executable,
Comparable<BatchRun> {
    protected Result result;
    public final Calendar timestamp;
    protected transient BatchRunAction parent;
    public final int id;
    public final String taskName;
    protected long duration;
    private static final Logger LOGGER = Logger.getLogger(BatchRun.class.getName());

    protected BatchRun(Calendar timestamp, BatchRunAction parent, int id, BatchTask task) {
        this.timestamp = timestamp;
        this.parent = parent;
        this.id = id;
        this.taskName = task.name;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean isRunning() {
        return this.result == null;
    }

    public String getTimestampString() {
        long time = new GregorianCalendar().getTimeInMillis() - this.timestamp.getTimeInMillis();
        return Util.getTimeSpanString((long)time);
    }

    public File getLogFile() {
        return new File(this.parent.owner.getRootDir(), "task-" + this.id + ".log");
    }

    public BatchTask getParent() {
        BatchTaskAction jta = (BatchTaskAction)this.parent.owner.getProject().getAction(BatchTaskAction.class);
        if (jta == null) {
            return null;
        }
        return jta.getTask(this.taskName);
    }

    public BatchRunAction getOwner() {
        return this.parent;
    }

    public BallColor getIconColor() {
        if (!this.isRunning()) {
            return this.getResult().color;
        }
        BatchRun previous = this.getPrevious();
        BallColor baseColor = previous == null ? BallColor.GREY_ANIME : previous.getIconColor();
        return baseColor.anime();
    }

    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public BatchRun getPrevious() {
        for (AbstractBuild b = this.parent.owner; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
            BatchRunAction records = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (records == null) continue;
            for (BatchRun r : records.records) {
                if (!r.taskName.equals(this.taskName) || r.timestamp.compareTo(this.timestamp) >= 0) continue;
                return r;
            }
        }
        return null;
    }

    public BatchRun getNext() {
        for (AbstractBuild b = this.parent.owner; b != null; b = (AbstractBuild)b.getNextBuild()) {
            BatchRunAction records = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (records == null) continue;
            for (BatchRun r : Iterators.reverse((List)records.records)) {
                if (!r.taskName.equals(this.taskName) || r.timestamp.compareTo(this.timestamp) <= 0) continue;
                return r;
            }
        }
        return null;
    }

    public String getUrl() {
        return this.parent.owner.getUrl() + "batchTasks/" + this.id;
    }

    public String getSearchUrl() {
        return this.getUrl();
    }

    public String getDisplayName() {
        return this.taskName + ' ' + this.getBuildNumber();
    }

    public String getNumber() {
        return this.parent.owner.getNumber() + "-" + this.id;
    }

    public String getBuildNumber() {
        return "#" + this.parent.owner.getNumber() + '-' + this.id;
    }

    public String getDurationString() {
        if (this.isRunning()) {
            return Util.getTimeSpanString((long)(System.currentTimeMillis() - this.timestamp.getTimeInMillis())) + " and counting";
        }
        return Util.getTimeSpanString((long)this.duration);
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamBuildListener listener = null;
        try {
            long start = System.currentTimeMillis();
            listener = new StreamBuildListener((OutputStream)new FileOutputStream(this.getLogFile()));
            Node node = Executor.currentExecutor().getOwner().getNode();
            Launcher launcher = node.createLauncher((TaskListener)listener);
            BatchTask task = this.getParent();
            if (task == null) {
                throw new AbortException("ERROR: undefined task \"" + this.taskName + "\"");
            }
            AbstractBuild lb = (AbstractBuild)task.owner.getLastBuild();
            FilePath ws = lb.getWorkspace();
            if (ws == null) {
                throw new AbortException(lb.getFullDisplayName() + " doesn't have a workspace.");
            }
            try {
                Environment environment;
                ArrayList<Environment> buildEnvironments = new ArrayList<Environment>();
                for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                    environment = nodeProperty.setUp(lb, launcher, (BuildListener)listener);
                    if (environment == null) continue;
                    buildEnvironments.add(environment);
                }
                for (NodeProperty nodeProperty : node.getNodeProperties()) {
                    environment = nodeProperty.setUp(lb, launcher, (BuildListener)listener);
                    if (environment == null) continue;
                    buildEnvironments.add(environment);
                }
                if (task.owner instanceof BuildableItemWithBuildWrappers) {
                    for (BuildWrapper bw : ((BuildableItemWithBuildWrappers)task.owner).getBuildWrappersList()) {
                        if (!"hudson.plugins.setenv.SetEnvBuildWrapper".equals(bw.getClass().getName()) || (environment = bw.setUp(lb, launcher, (BuildListener)listener)) == null) continue;
                        buildEnvironments.add(environment);
                    }
                }
                1 envAct = new /* Unavailable Anonymous Inner Class!! */;
                Object batchRunner = launcher.isUnix() ? new Shell(task.script) : new BatchFile(task.script);
                WorkspaceList.Lease wsLease = null;
                try {
                    wsLease = lb.getBuiltOn().toComputer().getWorkspaceList().acquire(ws, !task.owner.isConcurrentBuild());
                    lb.getActions().add(envAct);
                    this.result = batchRunner.perform(lb, launcher, (BuildListener)listener) ? Result.SUCCESS : Result.FAILURE;
                }
                finally {
                    if (wsLease != null) {
                        wsLease.release();
                    }
                    lb.getActions().remove(envAct);
                    for (Environment e : buildEnvironments) {
                        e.tearDown(lb, (BuildListener)listener);
                    }
                }
            }
            catch (InterruptedException e) {
                listener.getLogger().println("ABORTED");
                this.result = Result.ABORTED;
            }
            this.duration = System.currentTimeMillis() - start;
            this.parent.owner.save();
        }
        catch (AbortException e) {
            this.result = Result.FAILURE;
            listener.error(e.getMessage());
        }
        catch (IOException e) {
            this.result = Result.FAILURE;
            LOGGER.log(Level.SEVERE, "Failed to write " + this.getLogFile(), e);
        }
        finally {
            if (listener != null) {
                listener.getLogger().close();
            }
            if (this.result == null) {
                this.result = Result.FAILURE;
            }
        }
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new LargeText(this.getLogFile(), !this.isRunning()).doProgressText(req, rsp);
    }

    public String toString() {
        return this.parent.owner.toString() + '-' + this.id;
    }

    @Override
    public int compareTo(BatchRun that) {
        return that.timestamp.compareTo(this.timestamp);
    }

    public long getEstimatedDuration() {
        return this.getParent().getEstimatedDuration();
    }
}

