/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.batch_task.BatchRun;
import hudson.plugins.batch_task.BatchRunAction;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.plugins.batch_task.Messages;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskAction
implements Action {
    public final AbstractProject<?, ?> project;
    public final BatchTaskProperty property;

    public BatchTaskAction(AbstractProject<?, ?> project, BatchTaskProperty property) {
        this.project = project;
        this.property = property;
    }

    public List<BatchTask> getTasks() {
        return this.property.getTasks();
    }

    public String getIconFileName() {
        BatchRunAction bra;
        List tasks = this.property.getTasks();
        if (tasks.isEmpty()) {
            return null;
        }
        Run run = this.project.getLastBuild();
        BatchRunAction batchRunAction = bra = run != null ? (BatchRunAction)run.getAction(BatchRunAction.class) : null;
        if (bra != null) {
            for (BatchRun br : bra.records) {
                if (!br.isRunning()) continue;
                return br.getBuildStatusUrl();
            }
        }
        return "gear2.gif";
    }

    public String getDisplayName() {
        return Messages.BatchTaskAction_DisplayName((Object)this.property.getTasks().size());
    }

    public String getUrlName() {
        return "batchTasks";
    }

    public BatchTask getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        return this.getTask(name);
    }

    public BatchTask getTask(String name) {
        return this.property.getTask(name);
    }
}

