/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Result;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.SubTask;
import hudson.plugins.batch_task.BatchRun;
import hudson.plugins.batch_task.BatchRunAction;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.security.ACL;
import hudson.util.Iterators;
import hudson.widgets.BuildHistoryWidget;
import hudson.widgets.HistoryWidget;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchTask
extends AbstractModelObject
implements Queue.Task {
    public final String name;
    public final String script;
    transient AbstractProject<?, ?> owner;
    transient BatchTaskProperty parent;
    private static final HistoryWidget.Adapter<BatchRun> ADAPTER = new HistoryWidget.Adapter<BatchRun>(){

        public int compare(BatchRun record, String key) {
            int[] rhs;
            int[] lhs = this.parse(record.getNumber());
            int d = lhs[0] - (rhs = this.parse(key))[0];
            if (d != 0) {
                return d;
            }
            return lhs[1] - rhs[1];
        }

        public String getKey(BatchRun record) {
            return record.getNumber();
        }

        public boolean isBuilding(BatchRun record) {
            return record.isRunning();
        }

        public String getNextKey(String key) {
            int[] r = this.parse(key);
            r[1] = r[1] + 1;
            return r[0] + "-" + r[1];
        }

        private int[] parse(String num) {
            Matcher m = BUILD_NUMBER_PATTERN.matcher(num);
            if (m.matches()) {
                return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
            }
            return new int[]{0, 0};
        }
    };
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("(\\d+)-(\\d+)");

    @DataBoundConstructor
    public BatchTask(String name, String script) {
        this.name = name.trim();
        this.script = script;
    }

    public BatchTaskProperty getParent() {
        return this.parent;
    }

    public String getSearchUrl() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getFullDisplayName() {
        return this.owner.getFullDisplayName() + " \u00bb " + this.name;
    }

    public boolean isBuildBlocked() {
        return this.owner.isBuildBlocked();
    }

    public String getWhyBlocked() {
        return this.owner.getWhyBlocked();
    }

    public CauseOfBlockage getCauseOfBlockage() {
        return this.owner.getCauseOfBlockage();
    }

    public String getName() {
        return this.name;
    }

    public boolean isConcurrentBuild() {
        return false;
    }

    public long getEstimatedDuration() {
        BatchRun b = this.getLastSuccessfulRun();
        if (b == null) {
            return -1L;
        }
        long duration = b.getDuration();
        if (duration == 0L) {
            return -1L;
        }
        return duration;
    }

    public Label getAssignedLabel() {
        Node on = this.owner.getLastBuiltOn();
        if (on == null) {
            return null;
        }
        return on.getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return this.owner.getLastBuiltOn();
    }

    public String getBuildStatusUrl() {
        return this.getIconColor() + ".gif";
    }

    public BallColor getIconColor() {
        BatchRun r = this.getLastRun();
        if (r == null) {
            return BallColor.GREY;
        }
        return r.getIconColor();
    }

    public BatchRun getLastRun() {
        for (AbstractBuild b : this.owner.getBuilds()) {
            BatchRunAction bra = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (bra == null) continue;
            for (BatchRun br : bra.records) {
                if (!br.taskName.equals(this.name)) continue;
                return br;
            }
        }
        return null;
    }

    public BatchRun getLastSuccessfulRun() {
        for (BatchRun r = this.getLastRun(); r != null; r = r.getPrevious()) {
            if (r.getResult() != Result.SUCCESS) continue;
            return r;
        }
        return null;
    }

    public BatchRun getLastFailedRun() {
        for (BatchRun r = this.getLastRun(); r != null; r = r.getPrevious()) {
            if (r.getResult() != Result.FAILURE) continue;
            return r;
        }
        return null;
    }

    public Iterable<BatchRun> getRuns() {
        return new Iterable<BatchRun>(){

            @Override
            public Iterator<BatchRun> iterator() {
                return new Iterators.FlattenIterator<BatchRun, AbstractBuild<?, ?>>(BatchTask.this.owner.getBuilds().iterator()){

                    protected Iterator<BatchRun> expand(AbstractBuild<?, ?> b) {
                        BatchRunAction a = (BatchRunAction)b.getAction(BatchRunAction.class);
                        if (a == null) {
                            return Iterators.empty();
                        }
                        return a.getRecords(BatchTask.this.name).iterator();
                    }
                };
            }
        };
    }

    public HistoryWidget createHistoryWidget() {
        return new BuildHistoryWidget((Queue.Task)this, this.getRuns(), ADAPTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchRun createExecutable() throws IOException {
        BatchRunAction records;
        AbstractBuild lb = (AbstractBuild)this.owner.getLastBuild();
        if (lb == null) {
            return null;
        }
        AbstractBuild abstractBuild = lb;
        synchronized (abstractBuild) {
            records = (BatchRunAction)lb.getAction(BatchRunAction.class);
            if (records == null) {
                records = new BatchRunAction(lb);
                lb.addAction((Action)records);
            }
        }
        return records.createRecord(this);
    }

    public String getNextBuildNumber() {
        AbstractBuild lb = (AbstractBuild)this.owner.getLastBuild();
        if (lb == null) {
            return "0-0";
        }
        int id = 1;
        BatchRunAction records = (BatchRunAction)lb.getAction(BatchRunAction.class);
        if (records != null) {
            id = records.getRecords().size() + 1;
        }
        return lb.getNumber() + "-" + id;
    }

    public ACL getACL() {
        return this.owner.getACL();
    }

    public void checkAbortPermission() {
        this.getACL().checkPermission(AbstractProject.ABORT);
    }

    public boolean hasAbortPermission() {
        return this.getACL().hasPermission(AbstractProject.ABORT);
    }

    public boolean hasBuildPermission() {
        return this.getACL().hasPermission(AbstractProject.BUILD);
    }

    public boolean hasDeletePermission() {
        return this.getACL().hasPermission(AbstractProject.DELETE);
    }

    public boolean hasConfigurePermission() {
        return this.getACL().hasPermission(AbstractProject.CONFIGURE);
    }

    public ResourceList getResourceList() {
        return new ResourceList().w(this.owner.getWorkspaceResource());
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Matcher m = BUILD_NUMBER_PATTERN.matcher(token);
        if (m.matches()) {
            AbstractBuild b = (AbstractBuild)this.owner.getBuildByNumber(Integer.parseInt(m.group(1)));
            if (b == null) {
                return null;
            }
            BatchRunAction a = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (a == null) {
                return null;
            }
            return a.getRecord(Integer.parseInt(m.group(2)));
        }
        return null;
    }

    public synchronized void doExecute(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(AbstractProject.BUILD);
        if (this.owner.getLastBuild() != null) {
            Hudson.getInstance().getQueue().schedule((Queue.Task)this, 0, new Action[]{new CauseAction((Cause)new Cause.UserCause())});
            rsp.forwardToPreviousPage(req);
        } else {
            rsp.sendRedirect2("noBuild");
        }
    }

    public synchronized void doDoDelete(StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(AbstractProject.DELETE);
        this.getParent().removeTask(this);
        rsp.sendRedirect2("../..");
    }

    public void doCancelQueue(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkAbortPermission();
        Hudson.getInstance().getQueue().cancel((Queue.Task)this);
        rsp.forwardToPreviousPage(req);
    }

    public String getUrl() {
        return this.owner.getUrl() + "batchTasks/task/" + this.name + "/";
    }

    public Collection<? extends SubTask> getSubTasks() {
        return Collections.singleton(this);
    }

    public Queue.Task getOwnerTask() {
        return this;
    }

    public Object getSameNodeConstraint() {
        return null;
    }

    static {
        Queue.XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return BatchTask.class == klazz;
            }

            public Object fromString(String str) {
                int idx = str.lastIndexOf(47);
                if (idx < 0) {
                    throw new NoSuchElementException("Illegal format: " + str);
                }
                String projectName = str.substring(0, idx);
                Job job = (Job)Hudson.getInstance().getItemByFullName(projectName);
                if (job == null) {
                    throw new NoSuchElementException("No such job exists: " + projectName);
                }
                BatchTaskProperty bp = (BatchTaskProperty)job.getProperty(BatchTaskProperty.class);
                if (bp == null) {
                    throw new NoSuchElementException(projectName + " doesn't have the batck task anymore");
                }
                return bp.getTask(str.substring(idx + 1));
            }

            public String toString(Object item) {
                BatchTask bt = (BatchTask)((Object)item);
                return bt.owner.getFullName() + "/" + bt.name;
            }
        });
    }
}

