/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.batch_task.BatchTaskInvoker;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskInvoker
extends Publisher {
    private final Config[] configs;

    public BatchTaskInvoker(Config[] configs) {
        this.configs = configs;
    }

    public BatchTaskInvoker(JSONObject source) {
        ArrayList<Config> configs = new ArrayList<Config>();
        for (Object o : JSONArray.fromObject((Object)source.get("config"))) {
            configs.add(new Config((JSONObject)o));
        }
        this.configs = configs.toArray(new Config[configs.size()]);
    }

    public List<Config> getConfigs() {
        return Collections.unmodifiableList(Arrays.asList(this.configs));
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Config config : this.configs) {
            config.invoke(listener);
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }
}

