/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskProperty;
import hudson.plugins.batch_task.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTaskInvoker
extends Publisher {
    private final Config[] configs;

    public BatchTaskInvoker(Config[] configs) {
        this.configs = configs;
    }

    public BatchTaskInvoker(JSONObject source) {
        ArrayList<Config> configs = new ArrayList<Config>();
        for (Object o : JSONArray.fromObject((Object)source.get("config"))) {
            configs.add(new Config((JSONObject)o));
        }
        this.configs = configs.toArray(new Config[configs.size()]);
    }

    public List<Config> getConfigs() {
        return Collections.unmodifiableList(Arrays.asList(this.configs));
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Config config : this.configs) {
            config.invoke(listener);
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        private DescriptorImpl() {
            super(BatchTaskInvoker.class);
        }

        public String getDisplayName() {
            return Messages.BatchTaskInvoker_DisplayName();
        }

        public BatchTaskInvoker newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new BatchTaskInvoker(formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    public static final class Config {
        public final String project;
        public final String task;

        public Config(String project, String task) {
            this.project = project;
            this.task = task;
        }

        public Config(JSONObject source) {
            this(source.getString("project").trim(), source.getString("task").trim());
        }

        public BatchTaskProperty resolveProperty() {
            AbstractProject p = (AbstractProject)Hudson.getInstance().getItemByFullName(this.project, AbstractProject.class);
            if (p == null) {
                return null;
            }
            return (BatchTaskProperty)p.getProperty(BatchTaskProperty.class);
        }

        public BatchTask resolve() {
            BatchTaskProperty bp = this.resolveProperty();
            if (bp == null) {
                return null;
            }
            return bp.getTask(this.task);
        }

        public boolean invoke(BuildListener listener) {
            PrintStream logger = listener.getLogger();
            AbstractProject p = (AbstractProject)Hudson.getInstance().getItemByFullName(this.project, AbstractProject.class);
            if (p == null) {
                listener.error(Messages.BatchTaskInvoker_NoSuchProject(this.project));
                return false;
            }
            BatchTaskProperty bp = (BatchTaskProperty)p.getProperty(BatchTaskProperty.class);
            if (bp == null) {
                listener.error(Messages.BatchTaskInvoker_NoBatchTaskExists(this.task));
                return false;
            }
            BatchTask task = bp.getTask(this.task);
            if (task == null) {
                listener.error(Messages.BatchTaskInvoker_NoSuchTask((Object)task, bp.findNearestTask((String)this.task).name));
                return false;
            }
            logger.println(Messages.BatchTaskInvoker_Invoking(this.project, this.task, task.getNextBuildNumber()));
            Hudson.getInstance().getQueue().add((Queue.Task)task, 0);
            return true;
        }
    }
}

