/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.batch_task;

import hudson.AbortException;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BallColor;
import hudson.model.Executor;
import hudson.model.ModelObject;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.batch_task.BatchRunAction;
import hudson.plugins.batch_task.BatchTask;
import hudson.plugins.batch_task.BatchTaskAction;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import hudson.util.Iterators;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRun
implements Queue.Executable,
ModelObject,
Comparable<BatchRun> {
    protected Result result;
    public final Calendar timestamp;
    protected transient BatchRunAction parent;
    public final int id;
    public final String taskName;
    protected long duration;
    private static final Logger LOGGER = Logger.getLogger(BatchRun.class.getName());

    protected BatchRun(Calendar timestamp, BatchRunAction parent, int id, BatchTask task) {
        this.timestamp = timestamp;
        this.parent = parent;
        this.id = id;
        this.taskName = task.name;
    }

    public Result getResult() {
        return this.result;
    }

    public boolean isRunning() {
        return this.result == null;
    }

    public String getTimestampString() {
        long time = new GregorianCalendar().getTimeInMillis() - this.timestamp.getTimeInMillis();
        return Util.getTimeSpanString((long)time);
    }

    public File getLogFile() {
        return new File(this.parent.owner.getRootDir(), "task-" + this.id + ".log");
    }

    public BatchTask getParent() {
        BatchTaskAction jta = (BatchTaskAction)this.parent.owner.getProject().getAction(BatchTaskAction.class);
        if (jta == null) {
            return null;
        }
        return jta.getTask(this.taskName);
    }

    public BatchRunAction getOwner() {
        return this.parent;
    }

    public BallColor getIconColor() {
        if (!this.isRunning()) {
            return this.getResult().color;
        }
        BatchRun previous = this.getPrevious();
        BallColor baseColor = previous == null ? BallColor.GREY_ANIME : previous.getIconColor();
        return baseColor.anime();
    }

    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public BatchRun getPrevious() {
        for (AbstractBuild b = this.parent.owner; b != null; b = (AbstractBuild)b.getPreviousBuild()) {
            BatchRunAction records = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (records == null) continue;
            for (BatchRun r : records.records) {
                if (!r.taskName.equals(this.taskName) || r.timestamp.compareTo(this.timestamp) >= 0) continue;
                return r;
            }
        }
        return null;
    }

    public BatchRun getNext() {
        for (AbstractBuild b = this.parent.owner; b != null; b = (AbstractBuild)b.getNextBuild()) {
            BatchRunAction records = (BatchRunAction)b.getAction(BatchRunAction.class);
            if (records == null) continue;
            for (BatchRun r : Iterators.reverse(records.records)) {
                if (!r.taskName.equals(this.taskName) || r.timestamp.compareTo(this.timestamp) <= 0) continue;
                return r;
            }
        }
        return null;
    }

    public String getUrl() {
        return this.parent.owner.getUrl() + "batchTasks/" + this.id;
    }

    public String getDisplayName() {
        return this.taskName + ' ' + this.getBuildNumber();
    }

    public String getNumber() {
        return this.parent.owner.getNumber() + "-" + this.id;
    }

    public String getBuildNumber() {
        return "#" + this.parent.owner.getNumber() + '-' + this.id;
    }

    public String getDurationString() {
        if (this.isRunning()) {
            return Util.getTimeSpanString((long)(System.currentTimeMillis() - this.timestamp.getTimeInMillis())) + " and counting";
        }
        return Util.getTimeSpanString((long)this.duration);
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamTaskListener listener = null;
        try {
            long start = System.currentTimeMillis();
            listener = new StreamTaskListener(this.getLogFile());
            Launcher launcher = Executor.currentExecutor().getOwner().getNode().createLauncher((TaskListener)listener);
            BatchTask task = this.getParent();
            if (task == null) {
                throw new AbortException("ERROR: undefined taask \"" + this.taskName + "\"");
            }
            try {
                Object batchRunner = launcher.isUnix() ? new Shell(task.script) : new BatchFile(task.script);
                AbstractBuild lb = (AbstractBuild)task.owner.getLastBuild();
                if (lb.getWorkspace() == null) {
                    throw new AbortException(lb.getFullDisplayName() + " doesn't have a workspace.");
                }
                this.result = batchRunner.perform(lb, launcher, (TaskListener)listener) ? Result.SUCCESS : Result.FAILURE;
            }
            catch (InterruptedException e) {
                listener.getLogger().println("ABORTED");
                this.result = Result.ABORTED;
            }
            this.duration = System.currentTimeMillis() - start;
            this.parent.owner.save();
        }
        catch (AbortException e) {
            this.result = Result.FAILURE;
            listener.error(e.getMessage());
        }
        catch (IOException e) {
            this.result = Result.FAILURE;
            LOGGER.log(Level.SEVERE, "Failed to write " + this.getLogFile(), e);
        }
        finally {
            if (listener != null) {
                listener.close();
            }
            if (this.result == null) {
                this.result = Result.FAILURE;
            }
        }
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new LargeText(this.getLogFile(), !this.isRunning()).doProgressText(req, rsp);
    }

    public String toString() {
        return this.parent.owner.toString() + '-' + this.id;
    }

    @Override
    public int compareTo(BatchRun that) {
        return that.timestamp.compareTo(this.timestamp);
    }
}

