/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.bazaar.BazaarTagAction;
import hudson.scm.AbstractScmTagAction;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarTagAction
extends AbstractScmTagAction
implements Describable<BazaarTagAction> {
    private final List<BazaarRevision> revisions = new ArrayList();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    protected BazaarTagAction(AbstractBuild<?, ?> build) {
        super(build);
        new BazaarTagListener(this, null).register();
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        return "Tags";
    }

    public boolean isTagged() {
        if (!this.hasRevisions()) {
            return false;
        }
        for (BazaarRevision revision : this.revisions) {
            if (!revision.isTagged()) continue;
            return true;
        }
        return false;
    }

    public List<BazaarRevision> getRevisions() {
        return this.revisions;
    }

    public boolean hasRevisions() {
        return this.revisions != null && !this.revisions.isEmpty();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<BazaarRevision, String> newTags = new HashMap<BazaarRevision, String>();
        int i = -1;
        for (BazaarRevision e : this.revisions) {
            if (parser.get("tag" + ++i) == null || parser.get("name" + i).isEmpty()) continue;
            newTags.put(e, parser.get("name" + i));
        }
        new TagWorkerThread(this, newTags, parser.get("force") != null).start();
        rsp.sendRedirect(".");
    }

    public synchronized void doDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        if (req.getParameter("tag") != null) {
            BazaarRevision revision = null;
            String tag = null;
            for (BazaarRevision e : this.revisions) {
                if (!e.getRevId().equals(req.getParameter("revid"))) continue;
                revision = e;
                tag = req.getParameter("tag");
            }
            new TagDeletionWorkerThread(this, revision, tag).start();
        }
        rsp.sendRedirect(".");
    }

    public Descriptor<BazaarTagAction> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ List access$100(BazaarTagAction x0) {
        return x0.revisions;
    }

    static /* synthetic */ AbstractBuild access$200(BazaarTagAction x0) {
        return x0.build;
    }

    static /* synthetic */ AbstractBuild access$300(BazaarTagAction x0) {
        return x0.build;
    }
}

