/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.bazaar.BazaarAffectedFile;
import hudson.plugins.bazaar.BazaarChangeSet;
import hudson.plugins.bazaar.BazaarRepositoryBrowser;
import hudson.plugins.bazaar.browsers.OpenGrok;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class OpenGrok
extends BazaarRepositoryBrowser {
    public final URL url;
    private final String rootModule;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public OpenGrok(URL url, String rootModule) {
        this.url = OpenGrok.normalizeToEndWithSlash((URL)url);
        rootModule = rootModule.trim();
        if (rootModule.startsWith("/")) {
            rootModule = rootModule.substring(1);
        }
        if (rootModule.endsWith("/")) {
            rootModule = rootModule.substring(0, rootModule.length() - 1);
        }
        this.rootModule = rootModule;
    }

    public URL getChangeSetLink(BazaarChangeSet changeSet) throws IOException {
        return null;
    }

    public URL getDiffLink(BazaarAffectedFile affectedFile) throws IOException {
        URL url = null;
        String path = affectedFile.getPath().trim();
        if (affectedFile.getEditType() == EditType.EDIT && !OpenGrok.isFolderPath((String)path) && !OpenGrok.isRenaming((BazaarAffectedFile)affectedFile)) {
            int revision = OpenGrok.extractRevision((BazaarAffectedFile)affectedFile);
            path = this.getFullPath(path);
            url = new URL(this.url, String.format("./diff/%s?r1=/%s@%s&r2=/%s@%s", path, path, revision - 1, path, revision));
        }
        return url;
    }

    public URL getFileLink(BazaarAffectedFile affectedFile) throws IOException {
        URL url = null;
        String path = affectedFile.getPath().trim();
        if (affectedFile.getEditType() == EditType.EDIT && !OpenGrok.isFolderPath((String)path) && !OpenGrok.isRenaming((BazaarAffectedFile)affectedFile)) {
            int revision = OpenGrok.extractRevision((BazaarAffectedFile)affectedFile);
            path = this.getFullPath(path);
            url = new URL(this.url, String.format("./xref/%s?r=%s", path, revision));
        }
        return url;
    }

    private static int extractRevision(BazaarAffectedFile affectedFile) {
        return Integer.valueOf(affectedFile.getChangeSet().getRevision());
    }

    private String getFullPath(String path) {
        return this.rootModule + "/" + path;
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return DESCRIPTOR;
    }
}

