/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.bazaar.BazaarChangeLogParser;
import hudson.plugins.bazaar.BazaarRepositoryBrowser;
import hudson.plugins.bazaar.BazaarRevisionState;
import hudson.plugins.bazaar.BazaarSCM;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarSCM
extends SCM
implements Serializable {
    private final String source;
    private final boolean clean;
    private final BazaarRepositoryBrowser browser;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BazaarSCM.class.getName());

    @DataBoundConstructor
    public BazaarSCM(String source, boolean clean, BazaarRepositoryBrowser browser) {
        this.source = source;
        this.clean = clean;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isClean() {
        return this.clean;
    }

    @Exported
    public BazaarRepositoryBrowser getBrowser() {
        return this.browser;
    }

    private BazaarRevisionState getRevisionState(Launcher launcher, TaskListener listener, String root) throws InterruptedException {
        BazaarRevisionState rev = null;
        try {
            if (launcher == null) {
                launcher = new Launcher.LocalLauncher(listener);
            }
            PrintStream output = listener.getLogger();
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            ByteArrayOutputStream stderr = new ByteArrayOutputStream();
            String bzr_cmd = this.getDescriptor().getBzrExe();
            Launcher.ProcStarter starter = launcher.launch();
            starter = starter.cmds(new String[]{bzr_cmd, "revision-info", "-d", root});
            starter = starter.stdout((OutputStream)stdout);
            starter = starter.stderr((OutputStream)stderr);
            int ret = starter.join();
            String info_output = "bzr revision-info -d " + root + " returned " + ret + ". Command output: \"" + stdout.toString() + "\" stderr: \"" + stderr.toString() + "\"";
            if (ret != 0) {
                logger.warning(info_output);
            } else {
                String[] infos = stdout.toString().trim().split("\\s");
                rev = new BazaarRevisionState(infos[0], infos[1]);
            }
        }
        catch (IOException e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            logger.log(Level.WARNING, "Failed to poll repository: ", e);
        }
        if (rev == null) {
            logger.log(Level.WARNING, "Failed to get revision state for: {0}", root);
        }
        return rev;
    }

    private void getLog(Launcher launcher, FilePath workspace, BazaarRevisionState oldRevisionState, BazaarRevisionState newRevisionState, File changeLog) throws InterruptedException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String version = "revid:" + oldRevisionState.getRevId() + "..revid:" + newRevisionState.getRevId();
            int ret = launcher.launch().cmds(new String[]{this.getDescriptor().getBzrExe(), "log", "-v", "-r", version, "--long", "--show-ids"}).envs(EnvVars.masterEnvVars).stdout((OutputStream)baos).pwd(workspace).join();
            if (ret != 0) {
                logger.log(Level.WARNING, "bzr log -v -r returned {0}", ret);
            } else {
                FileOutputStream fos = new FileOutputStream(changeLog);
                fos.write(baos.toByteArray());
                fos.close();
            }
        }
        catch (IOException e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            logger.log(Level.WARNING, "Failed to poll repository: ", e);
        }
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        output.printf("Getting current remote revision...", new Object[0]);
        BazaarRevisionState remote = this.getRevisionState(launcher, listener, this.source);
        output.println(remote);
        output.printf("Baseline is %s.\n", baseline);
        PollingResult.Change change = baseline == SCMRevisionState.NONE || baseline.getClass() != BazaarRevisionState.class || !remote.equals((Object)baseline) ? PollingResult.Change.SIGNIFICANT : PollingResult.Change.NONE;
        return new PollingResult(baseline, (SCMRevisionState)remote, change);
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        output.println("Getting local revision...");
        BazaarRevisionState local = this.getRevisionState(launcher, listener, build.getWorkspace().getRemote());
        output.println(local);
        return local;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        if (canUpdate) {
            return this.update(this.clean, build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    private boolean update(boolean clean, AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        BazaarRevisionState oldRevisionState = this.getRevisionState(launcher, (TaskListener)listener, workspace.getRemote());
        boolean hasProblemOccured = false;
        if (clean) {
            hasProblemOccured = !this.branch(build, launcher, workspace, listener);
        } else {
            boolean bl = hasProblemOccured = !this.pull(build, launcher, workspace, listener);
        }
        if (hasProblemOccured) {
            return false;
        }
        BazaarRevisionState newRevisionState = this.getRevisionState(launcher, (TaskListener)listener, workspace.getRemote());
        this.getLog(launcher, workspace, oldRevisionState, newRevisionState, changelogFile);
        return true;
    }

    private boolean pull(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getBzrExe(), "pull", "--overwrite", this.source});
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join() != 0) {
                listener.error("Failed to pull");
                return false;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            return false;
        }
        return true;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        if (!this.branch(build, launcher, workspace, listener)) {
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    private boolean branch(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws InterruptedException {
        try {
            listener.getLogger().println("Cleaning workspace...");
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getBzrExe(), "branch", this.source, workspace.getRemote()});
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        return true;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        BazaarRevisionState revisionState = (BazaarRevisionState)build.getAction(SCMRevisionState.class);
        if (revisionState != null) {
            if (revisionState.getRevNo() != null) {
                env.put("BZR_REVISION", revisionState.getRevNo());
            }
            if (revisionState.getRevId() != null) {
                env.put("BZR_REVID", revisionState.getRevId());
            }
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new BazaarChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }
}

