/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.bazaar.BazaarAffectedFile;
import hudson.plugins.bazaar.BazaarChangeSet;
import hudson.plugins.bazaar.BazaarRepositoryBrowser;
import hudson.plugins.bazaar.browsers.Loggerhead;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Loggerhead
extends BazaarRepositoryBrowser {
    public final URL url;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public Loggerhead(URL url) {
        this.url = Loggerhead.normalizeToEndWithSlash((URL)url);
    }

    public URL getChangeSetLink(BazaarChangeSet changeSet) throws IOException {
        return new URL(this.url, "./revision/" + changeSet.getRevno());
    }

    public URL getDiffLink(BazaarAffectedFile affectedFile) throws IOException {
        URL url = null;
        String path = affectedFile.getPath().trim();
        if (!Loggerhead.isFolderPath((String)path) && !Loggerhead.isRenaming((BazaarAffectedFile)affectedFile)) {
            return new URL(this.url, String.format("./revision/%s/%s", affectedFile.getChangeSet().getRevno(), Loggerhead.trimHeadSlash((String)path)));
        }
        return url;
    }

    public URL getFileLink(BazaarAffectedFile affectedFile) throws IOException {
        String path = affectedFile.getPath().trim();
        return new URL(this.url, String.format("./%s/%s/%s?file_id=%s", Loggerhead.getBrowsingType((String)path), affectedFile.getChangeSet().getRevno(), Loggerhead.trimHeadSlash((String)path), affectedFile.getFileId()));
    }

    private static String getBrowsingType(String path) {
        String browsingType = "annotate";
        if (Loggerhead.isFolderPath((String)path)) {
            browsingType = "files";
        }
        return browsingType;
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return DESCRIPTOR;
    }
}

