/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bazaar;

import hudson.model.User;
import hudson.plugins.bazaar.BazaarAffectedFile;
import hudson.scm.ChangeLogSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarChangeSet
extends ChangeLogSet.Entry {
    private String author;
    private String revno;
    private String revid;
    private String date;
    private String msg;
    private List<BazaarAffectedFile> affectedFiles = new ArrayList<BazaarAffectedFile>();

    @Exported
    public String getMsg() {
        return this.msg;
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.author);
    }

    @Exported
    public String getRevno() {
        return this.revno;
    }

    @Exported
    public String getRevision() {
        return this.getRevno();
    }

    @Exported
    public String getRevid() {
        return this.revid;
    }

    @Exported
    public String getDate() {
        return this.date;
    }

    public Collection<String> getAffectedPaths() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((BazaarAffectedFile)BazaarChangeSet.this.affectedFiles.get(index)).getPath();
            }

            @Override
            public int size() {
                return BazaarChangeSet.this.affectedFiles.size();
            }
        };
    }

    public Collection<BazaarAffectedFile> getAffectedFiles() {
        return this.affectedFiles;
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setUser(String author) {
        this.author = author;
    }

    public String getUser() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setRevno(String revno) {
        this.revno = revno;
    }

    public void setRevid(String revid) {
        this.revid = revid;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void addAffectedFile(BazaarAffectedFile affectedFile) {
        affectedFile.setChangeSet(this);
        this.affectedFiles.add(affectedFile);
    }
}

