/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bitkeeper;

import hudson.model.AbstractBuild;
import hudson.plugins.bitkeeper.BitKeeperChangeSetList;
import hudson.plugins.bitkeeper.BitKeeperChangeset;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitKeeperChangeLogParser
extends ChangeLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        BitKeeperChangeset cset;
        BufferedReader changelog = null;
        ArrayList<BitKeeperChangeset> changes = new ArrayList<BitKeeperChangeset>();
        try {
            String line;
            changelog = new BufferedReader(new FileReader(changelogFile));
            cset = null;
            while ((line = changelog.readLine()) != null) {
                if (line.startsWith("U ")) {
                    if (cset != null) {
                        changes.add(cset);
                    }
                    cset = new BitKeeperChangeset(line.substring(2));
                    continue;
                }
                if (line.startsWith("C ")) {
                    cset.addComment(line.substring(2));
                    continue;
                }
                if (!line.startsWith("F ")) continue;
                cset.addPath(line.substring(2));
            }
        }
        finally {
            if (changelog != null) {
                changelog.close();
            }
        }
        if (cset != null) {
            changes.add(cset);
        }
        return new BitKeeperChangeSetList(build, changes);
    }
}

