/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bitkeeper;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.bitkeeper.BitKeeperChangeLogParser;
import hudson.plugins.bitkeeper.BitKeeperTagAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ByteBuffer;
import hudson.util.FormFieldValidator;
import hudson.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitKeeperSCM
extends SCM {
    private final String parent;
    private final String localRepository;
    private final boolean usePull;
    private final boolean quiet;
    private final int maxAttempts = 9;

    @DataBoundConstructor
    public BitKeeperSCM(String parent, String localRepo, boolean usePull, boolean quiet) {
        this.parent = parent;
        this.localRepository = localRepo;
        this.usePull = usePull;
        this.quiet = quiet;
    }

    public String getParent() {
        return this.parent;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public boolean isUsePull() {
        return this.usePull;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return workspace.child(this.localRepository);
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        FilePath localRepo = workspace.child(this.localRepository);
        if (this.usePull && localRepo.exists()) {
            this.pullLocalRepo(build, launcher, listener, workspace);
        } else {
            this.cloneLocalRepo(build, launcher, (TaskListener)listener, workspace);
        }
        this.saveChangelog(build, launcher, listener, changelogFile, localRepo);
        String mostRecent = this.getLatestChangeset(build.getEnvVars(), launcher, workspace, this.localRepository, (TaskListener)listener);
        build.addAction((Action)new BitKeeperTagAction(build, mostRecent));
        return true;
    }

    private void pullLocalRepo(AbstractBuild build, Launcher launcher, BuildListener listener, FilePath workspace) throws IOException, InterruptedException, AbortException {
        FilePath localRepo = workspace.child(this.localRepository);
        PrintStream output = listener.getLogger();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getDescriptor().getBkExe());
        args.add("pull");
        args.add("-u");
        args.add("-c9");
        if (this.quiet) {
            args.add("-q");
        }
        args.add(this.parent);
        if (launcher.launch(args.toArray(new String[args.size()]), build.getEnvVars(), (OutputStream)output, localRepo).join() != 0) {
            listener.error("Failed to pull from " + this.parent);
            throw new AbortException();
        }
        output.println("Pull completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChangelog(AbstractBuild build, Launcher launcher, BuildListener listener, File changelogFile, FilePath localRepo) throws IOException, InterruptedException, FileNotFoundException, AbortException {
        FileOutputStream changelog = null;
        Run prevBuild = build.getPreviousBuild();
        BitKeeperTagAction tagAction = prevBuild == null ? null : (BitKeeperTagAction)prevBuild.getAction(BitKeeperTagAction.class);
        String recentCset = tagAction == null ? null : tagAction.getCsetkey();
        try {
            changelog = new FileOutputStream(changelogFile);
            if (recentCset == null || recentCset.equals("")) {
                listener.error("No most recent changeset available for changelog");
                return;
            }
            if (launcher.launch(new String[]{this.getDescriptor().getBkExe(), "changes", "-v", "-r" + recentCset + "..", "-d$if(:CHANGESET:){U :USER:\n$each(:C:){C (:C:)\n}$each(:TAG:){T (:TAG:)\n}}$unless(:CHANGESET:){F :GFILE:\n}"}, build.getEnvVars(), (OutputStream)changelog, localRepo).join() != 0) {
                listener.error("Failed to save changelog");
                throw new AbortException();
            }
        }
        finally {
            if (changelog != null) {
                ((OutputStream)changelog).close();
            }
        }
        listener.getLogger().println("Changelog saved");
    }

    public ChangeLogParser createChangeLogParser() {
        return new BitKeeperChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        Run lastBuild = project.getLastBuild();
        BitKeeperTagAction tagAction = lastBuild == null ? null : (BitKeeperTagAction)lastBuild.getAction(BitKeeperTagAction.class);
        String recentCset = tagAction == null ? null : tagAction.getCsetkey();
        String cset = this.getLatestChangeset(Collections.<String, String>emptyMap(), launcher, workspace, this.parent, listener);
        return !cset.equals(recentCset);
    }

    private String getLatestChangeset(Map<String, String> env, Launcher launcher, FilePath workspace, String repository, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (launcher.launch(new String[]{this.getDescriptor().getBkExe(), "changes", "-r+", "-d:CSETKEY:", "-D", repository}, env, (OutputStream)baos, workspace).join() != 0) {
            Util.copyStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)listener.getLogger());
            listener.error("Failed to check the latest changeset");
            throw new AbortException();
        }
        String rev = null;
        int i$ = 0;
        String[] arr$ = Util.tokenize((String)new String(baos.toByteArray(), "ASCII"), (String)"\r\n");
        int len$ = arr$.length;
        if (i$ < len$) {
            String line = arr$[i$];
            rev = line = line.trim();
        }
        if (rev == null) {
            Util.copyStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)listener.getLogger());
            listener.error("Failed to identify a revision");
            throw new AbortException();
        }
        return rev;
    }

    private void cloneLocalRepo(AbstractBuild build, Launcher launcher, TaskListener listener, FilePath workspace) throws InterruptedException, IOException {
        FilePath localRepo = workspace.child(this.localRepository);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getDescriptor().getBkExe());
        args.add("clone");
        if (this.quiet) {
            args.add("-q");
        }
        args.add(this.parent);
        args.add(this.localRepository);
        PrintStream output = listener.getLogger();
        int attempt = 0;
        int result = 0;
        do {
            if (result != 0) {
                Thread.sleep(30000L);
                listener.error("Retrying clone");
            }
            localRepo.deleteRecursive();
            result = launcher.launch(args.toArray(new String[args.size()]), build.getEnvVars(), (OutputStream)output, workspace).join();
        } while (++attempt < 9 && result != 0);
        if (result != 0) {
            listener.error("Failed to clone after 9 attempts from " + this.parent);
            throw new AbortException();
        }
        output.println("New clone made");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<BitKeeperSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String bkExe;
        private static final Pattern VERSION_STRING = Pattern.compile("BitKeeper version is bk-([0-9.]+)");
        private static final VersionNumber V4_0_1 = new VersionNumber("4.0.1");

        private DescriptorImpl() {
            super(BitKeeperSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "BitKeeper";
        }

        public String getBkExe() {
            if (this.bkExe == null) {
                return "bk";
            }
            return this.bkExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new BitKeeperSCM(req.getParameter("bitkeeper.parent"), req.getParameter("bitkeeper.localRepository"), req.getParameter("bitkeeper.usePull") != null, req.getParameter("bitkeeper.quiet") != null);
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.bkExe = req.getParameter("bitkeeper.bkExe");
            this.save();
            return true;
        }

        public void doBkExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    block7: {
                        ByteBuffer baos = new ByteBuffer();
                        try {
                            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{DescriptorImpl.this.getBkExe(), "version"}, new String[0], (OutputStream)baos, null);
                            proc.join();
                            Matcher m = VERSION_STRING.matcher(baos.toString());
                            if (!m.find()) break block7;
                            try {
                                if (new VersionNumber(m.group(1)).compareTo(V4_0_1) >= 0) {
                                    this.ok();
                                } else {
                                    this.error("This bk is version " + m.group(1) + " but we need 4.0.1+");
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.warning("Hudson can't tell if this bk is 4.0.1 or later (detected version is %s)", new Object[]{m.group(1)});
                            }
                            return;
                        }
                        catch (IOException e) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.error("Unable to check bk version");
                }
            }.process();
        }
    }
}

