/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.blacklist.features;

import hudson.DescriptorExtensionList;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.plugins.blacklist.BlacklistedFeature;
import org.hudsonci.plugins.blacklist.internal.DescriptorLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
class M2ProjectFeature
implements BlacklistedFeature {
    private static final String HUDSON_M2_JOB_TYPE = "hudson.maven.MavenModuleSet";
    private final DescriptorLocator locator;

    @Inject
    public M2ProjectFeature(DescriptorLocator locator) {
        this.locator = locator;
    }

    @Override
    public void disable() {
        DescriptorExtensionList<TopLevelItem, Descriptor<TopLevelItem>> topLevelItemDescriptors = this.getTopLevelItemDescriptors();
        Descriptor bannedExtension = topLevelItemDescriptors.findByName(HUDSON_M2_JOB_TYPE);
        if (bannedExtension != null) {
            topLevelItemDescriptors.remove((Object)bannedExtension);
            Functions.getGlobalConfigIgnoredDescriptors().add(bannedExtension.getClass().getName());
        }
    }

    @Override
    public void enable() {
        Descriptor extenstionToEnable = this.locator.getDescriptor(HUDSON_M2_JOB_TYPE);
        DescriptorExtensionList<TopLevelItem, Descriptor<TopLevelItem>> topLevelItemDescriptors = this.getTopLevelItemDescriptors();
        Descriptor previouslyRemovedExtension = topLevelItemDescriptors.findByName(HUDSON_M2_JOB_TYPE);
        if (extenstionToEnable != null && previouslyRemovedExtension == null) {
            topLevelItemDescriptors.add((Object)extenstionToEnable);
            Functions.getGlobalConfigIgnoredDescriptors().remove(extenstionToEnable.getClass().getName());
        }
    }

    private DescriptorExtensionList<TopLevelItem, Descriptor<TopLevelItem>> getTopLevelItemDescriptors() {
        return this.locator.getDescriptorList(TopLevelItem.class);
    }
}

