/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.blacklist.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.plugins.blacklist.BlacklistManager;
import org.hudsonci.plugins.blacklist.BlacklistedFeature;
import org.hudsonci.plugins.blacklist.internal.FeatureIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class BlacklistManagerImpl
implements BlacklistManager {
    private static final Logger log = LoggerFactory.getLogger(BlacklistManager.class);
    private final Map<String, BlacklistedFeature> features;

    @Inject
    public BlacklistManagerImpl(List<BlacklistedFeature> features, FeatureIndexer indexer) {
        assert (features != null);
        this.features = indexer.mapFeaturesToSimpleName(features);
    }

    public Collection<BlacklistedFeature> getManagedFeatures() {
        return this.features.values();
    }

    @Override
    public void disableAllFeatures() {
        for (BlacklistedFeature feature : this.features.values()) {
            this.disable(feature);
        }
    }

    @Override
    public void enableAllFeatures() {
        for (BlacklistedFeature feature : this.features.values()) {
            this.enable(feature);
        }
    }

    @Override
    public void disableFeature(String featureName) {
        BlacklistedFeature feature = this.features.get(featureName);
        if (feature != null) {
            this.disable(feature);
        }
    }

    @Override
    public void enableFeature(String featureName) {
        BlacklistedFeature feature = this.features.get(featureName);
        if (feature != null) {
            this.enable(feature);
        }
    }

    private void disable(BlacklistedFeature feature) {
        log.debug("Disabling feature {}", (Object)feature.getClass().getSimpleName());
        feature.disable();
    }

    private void enable(BlacklistedFeature feature) {
        log.debug("Enabling feature {}", (Object)feature.getClass().getSimpleName());
        feature.enable();
    }
}

