/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.bugzilla.BugzillaProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaChangelogAnnotator
extends ChangeLogAnnotator {
    public static final Pattern PATTERN = Pattern.compile("\\b[1-9][0-9]*\\b");

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        for (MarkupText.SubText token : text.findTokens(PATTERN)) {
            String id = token.group(0);
            String baseUrl = BugzillaProjectProperty.DESCRIPTOR.getBaseUrl();
            token.surroundWith("<a href='" + baseUrl + "/show_bug.cgi?id=" + id + "'>", "</a>");
        }
    }
}

