/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private String baseUrl;

        public DescriptorImpl() {
            super(BugzillaProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Bugzilla";
        }

        public JobProperty<?> newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new BugzillaProjectProperty();
        }

        public boolean configure(StaplerRequest req) {
            this.baseUrl = req.getParameter("bugzilla.base");
            this.save();
            return true;
        }

        public String getBaseUrl() {
            if (this.baseUrl == null) {
                return "http://bugzilla";
            }
            return this.baseUrl;
        }

        public void doUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.URLCheck(req, rsp){

                protected void check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (url == null) {
                        this.error("No bugzilla base URL");
                        return;
                    }
                    try {
                        if (this.findText(this.open(new URL(url)), "bugzilla")) {
                            this.ok();
                        } else {
                            this.error("This is not a bugzilla URL");
                        }
                    }
                    catch (IOException e) {
                        this.error("Unable to connect to URL");
                    }
                }
            }.process();
        }

        public void save() {
            super.save();
        }
    }
}

