/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaSession {
    String url;
    String username;
    String password;
    transient XmlRpcClient client;
    private static final Logger LOGGER = Logger.getLogger(BugzillaSession.class.getName());
    private static final int LOGIN_REQUIRED = 410;

    public BugzillaSession(String u) throws XmlRpcException, MalformedURLException {
        this(u, null, null);
    }

    public BugzillaSession(String u, String username, String password) throws XmlRpcException, MalformedURLException {
        try {
            this.url = u;
            this.username = username;
            this.password = password;
            this.initClient();
            HashMap result = this.execute("Bugzilla.version", null);
            String version = (String)result.get("version");
            LOGGER.log(Level.INFO, "Bugzilla server version is " + version);
        }
        catch (XmlRpcException e) {
            LOGGER.log(Level.WARNING, "XmlRpcException starting bugzilla session: " + e.getMessage());
            throw e;
        }
    }

    private void initClient() throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        URL urlobj = new URL(this.url + "/xmlrpc.cgi");
        if (urlobj.getHost() == null) {
            throw new MalformedURLException();
        }
        config.setServerURL(urlobj);
        this.client = new XmlRpcClient();
        XmlRpcCommonsTransportFactory transportFactory = new XmlRpcCommonsTransportFactory(this.client);
        transportFactory.setHttpClient(new HttpClient());
        this.client.setTransportFactory((XmlRpcTransportFactory)transportFactory);
        this.client.setConfig((XmlRpcClientConfig)config);
    }

    public boolean login() {
        if (this.username == null || this.password == null) {
            LOGGER.fine("Username or password missing, assuming not necessary");
            return true;
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("login", this.username);
            args.put("password", this.password);
            HashMap result = this.execute("User.login", args);
            if (result.containsKey("id")) {
                LOGGER.fine("Successful bugzilla login - ID " + result.get("id"));
                return true;
            }
            LOGGER.log(Level.WARNING, "No 'id' after XMLRPC Bugzilla login");
            return false;
        }
        catch (XmlRpcException e) {
            LOGGER.log(Level.WARNING, "XMLRPC cannot log in to bugzilla: " + e.getMessage());
            return false;
        }
    }

    public HashMap<Integer, String> getBugSummaryMap(HashSet<Integer> bugIds) {
        if (bugIds.size() == 0) {
            return null;
        }
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        try {
            ArrayList<Integer> argIds = new ArrayList<Integer>(bugIds);
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            params.put("ids", argIds);
            HashMap result = this.execute("Bug.get_bugs", params);
            Object[] bugs = (Object[])result.get("bugs");
            LOGGER.fine("get_bugs result has " + bugs.length);
            for (Object bug : bugs) {
                HashMap bugMap = (HashMap)bug;
                Integer id = (Integer)bugMap.get("id");
                String summary = (String)bugMap.get("summary");
                ret.put(id, summary);
            }
        }
        catch (XmlRpcException e) {
            LOGGER.log(Level.WARNING, "XMLRPC problem getting bug summaries: " + e.getMessage());
            return null;
        }
        return ret;
    }

    private HashMap<String, Object> execute(String method, HashMap<String, Object> args) throws XmlRpcException {
        if (this.client == null) {
            try {
                this.initClient();
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        boolean exit = false;
        HashMap ret = null;
        while (ret == null) {
            try {
                Object[] objectArray;
                if (args == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = args;
                }
                ret = (HashMap)this.client.execute(method, objectArray);
            }
            catch (XmlRpcException e) {
                if (exit || e.code != 410) {
                    LOGGER.log(Level.FINE, "XmlRpcException for \"" + method + "\" error code '" + e.code + "'", e);
                    throw e;
                }
                LOGGER.log(Level.FINE, "Login required for \"" + method + "\".  Attempting.");
                exit = true;
                this.login();
            }
        }
        return ret;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

