/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.bugzilla.BugzillaProjectProperty;
import hudson.plugins.bugzilla.BugzillaSession;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaChangelogAnnotator
extends ChangeLogAnnotator {
    public static final Pattern PATTERN = Pattern.compile("\\b[0-9.]*[0-9]\\b");

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        HashSet<Integer> bugIds = new HashSet<Integer>();
        for (MarkupText.SubText token : text.findTokens(PATTERN)) {
            String id = token.group(0);
            try {
                bugIds.add(Integer.valueOf(id));
            }
            catch (NumberFormatException e) {}
        }
        BugzillaSession bugzillaSession = BugzillaProjectProperty.DESCRIPTOR.getBugzillaSession();
        HashMap<Integer, String> summaryMap = bugzillaSession == null ? null : bugzillaSession.getBugSummaryMap(bugIds);
        for (MarkupText.SubText token : text.findTokens(PATTERN)) {
            String id = token.group(0);
            Integer key = null;
            try {
                key = Integer.valueOf(id);
            }
            catch (NumberFormatException e) {
                continue;
            }
            String baseUrl = BugzillaProjectProperty.DESCRIPTOR.getBaseUrl();
            if (summaryMap == null) {
                token.surroundWith(String.format("<a href='%s/show_bug.cgi?id=%d'>", baseUrl, key), "</a>");
                continue;
            }
            if (!summaryMap.containsKey(key)) continue;
            String summary = summaryMap.get(key);
            token.surroundWith(String.format("<a href='%s/show_bug.cgi?id=%d' tooltip='%s'>", baseUrl, key, summary), "</a>");
        }
    }
}

