/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.bugzilla.BugzillaSession;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import org.apache.xmlrpc.XmlRpcException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private BugzillaSession bugzillaSession;

        public DescriptorImpl() {
            super(BugzillaProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Bugzilla";
        }

        public JobProperty<?> newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new BugzillaProjectProperty();
        }

        public boolean configure(StaplerRequest req) {
            try {
                this.bugzillaSession = new BugzillaSession(req.getParameter("bugzilla.base"), req.getParameter("bugzilla.username"), req.getParameter("bugzilla.password"));
            }
            catch (MalformedURLException e) {
            }
            catch (XmlRpcException xmlRpcException) {
                // empty catch block
            }
            this.save();
            return true;
        }

        public String getBaseUrl() {
            if (this.bugzillaSession == null) {
                return "http://bugzilla";
            }
            return this.bugzillaSession.getUrl();
        }

        public String getUsername() {
            if (this.bugzillaSession == null) {
                return "";
            }
            return this.bugzillaSession.getUsername();
        }

        public String getPassword() {
            if (this.bugzillaSession == null) {
                return "";
            }
            return this.bugzillaSession.getPassword();
        }

        public BugzillaSession getBugzillaSession() {
            return this.bugzillaSession;
        }

        public void doUrlCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.URLCheck(req, rsp){

                protected void check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (url == null) {
                        this.error("No bugzilla base URL");
                        return;
                    }
                    try {
                        new BugzillaSession(url);
                        this.ok();
                        return;
                    }
                    catch (MalformedURLException e) {
                        this.error("Not a valid URL");
                        return;
                    }
                    catch (XmlRpcException e) {
                        this.error("Error contacting bugzilla XMLRPC at this URL");
                        return;
                    }
                }
            }.process();
        }

        public void doLoginCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)this.request.getParameter("url"));
                    if (url == null) {
                        this.ok();
                        return;
                    }
                    BugzillaSession bsess = null;
                    try {
                        bsess = new BugzillaSession(url, this.request.getParameter("user"), this.request.getParameter("pass"));
                    }
                    catch (XmlRpcException e) {
                        this.ok();
                        return;
                    }
                    if (bsess.login()) {
                        this.ok();
                    } else {
                        this.error("Invalid username/password");
                    }
                }
            }.process();
        }

        public void save() {
            super.save();
        }
    }
}

