/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.bugzilla.BugzillaProjectProperty;
import hudson.plugins.bugzilla.BugzillaSession;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaChangelogAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(BugzillaChangelogAnnotator.class.getName());

    private static int getId(MarkupText.SubText token) {
        String id = null;
        int i = 0;
        while (true) {
            id = token.group(i);
            try {
                return Integer.valueOf(id);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "{0} is not a number in group {1}, trying next group", new Object[]{id, i});
                ++i;
                continue;
            }
            break;
        }
    }

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        Pattern pattern = null;
        String regex = BugzillaProjectProperty.DESCRIPTOR.getRegex();
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.log(Level.WARNING, "Cannot compile pattern: {0}", regex);
            return;
        }
        HashSet<Integer> bugIds = new HashSet<Integer>();
        if (BugzillaProjectProperty.DESCRIPTOR.getUseToolTips()) {
            for (MarkupText.SubText token : text.findTokens(pattern)) {
                try {
                    bugIds.add(BugzillaChangelogAnnotator.getId(token));
                }
                catch (NumberFormatException e) {}
            }
        }
        BugzillaSession bugzillaSession = BugzillaProjectProperty.DESCRIPTOR.getBugzillaSession();
        HashMap<Integer, String> summaryMap = null;
        if (!bugIds.isEmpty() && bugzillaSession != null) {
            summaryMap = bugzillaSession.getBugSummaryMap(bugIds);
        }
        for (MarkupText.SubText token : text.findTokens(pattern)) {
            Integer key = null;
            try {
                key = BugzillaChangelogAnnotator.getId(token);
            }
            catch (Exception e) {
                continue;
            }
            String baseUrl = BugzillaProjectProperty.DESCRIPTOR.getBaseUrl();
            if (summaryMap == null) {
                token.surroundWith(String.format("<a href='%s/show_bug.cgi?id=%d'>", baseUrl, key), "</a>");
                continue;
            }
            if (!summaryMap.containsKey(key)) continue;
            String summary = summaryMap.get(key);
            token.surroundWith(String.format("<a href='%s/show_bug.cgi?id=%d' tooltip='%s'>", baseUrl, key, summary), "</a>");
        }
    }
}

