/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.bugzilla;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.bugzilla.BugzillaSession;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.xmlrpc.XmlRpcException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private BugzillaSession bugzillaSession;
        private String regex;
        private boolean useTooltips;

        public DescriptorImpl() {
            super(BugzillaProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Bugzilla";
        }

        public BugzillaProjectProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new BugzillaProjectProperty();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            try {
                this.regex = req.getParameter("bugzilla.regex");
                if (req.getParameter("bugzilla.usetooltips") == null) {
                    this.useTooltips = false;
                    this.bugzillaSession = new BugzillaSession(req.getParameter("bugzilla.base"));
                } else {
                    this.useTooltips = true;
                    this.bugzillaSession = new BugzillaSession(req.getParameter("bugzilla.base"), req.getParameter("bugzilla.username"), req.getParameter("bugzilla.password"));
                }
            }
            catch (MalformedURLException e) {
            }
            catch (XmlRpcException xmlRpcException) {
                // empty catch block
            }
            this.save();
            return true;
        }

        public String getBaseUrl() {
            if (this.bugzillaSession == null) {
                return "http://bugzilla";
            }
            return this.bugzillaSession.getUrl();
        }

        public String getUsername() {
            if (this.bugzillaSession == null) {
                return "";
            }
            return this.bugzillaSession.getUsername();
        }

        public String getPassword() {
            if (this.bugzillaSession == null) {
                return "";
            }
            return this.bugzillaSession.getPassword();
        }

        public boolean getUseToolTips() {
            return this.useTooltips;
        }

        public String getRegex() {
            if (this.regex == null) {
                return "\\b[0-9.]*[0-9]\\b";
            }
            return this.regex;
        }

        public BugzillaSession getBugzillaSession() {
            return this.bugzillaSession;
        }

        public FormValidation doRegexCheck(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"No Bug ID regex");
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)"Pattern cannot be compiled");
            }
        }

        public FormValidation doUrlCheck(final @QueryParameter String value) throws IOException, ServletException {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.error((String)"No bugzilla base URL");
                    }
                    try {
                        new BugzillaSession(url).checkVersion();
                        return FormValidation.ok();
                    }
                    catch (MalformedURLException e) {
                        return FormValidation.error((String)"Not a valid URL");
                    }
                    catch (XmlRpcException e) {
                        return FormValidation.error((String)"Error contacting bugzilla XMLRPC at this URL - tooltips may not work");
                    }
                }
            }.check();
        }

        public FormValidation doLoginCheck(@QueryParameter String url, @QueryParameter String user, @QueryParameter String pass) throws IOException {
            if (Util.fixEmpty((String)url) == null) {
                return FormValidation.ok();
            }
            BugzillaSession bsess = null;
            try {
                bsess = new BugzillaSession(url, user, pass);
                bsess.checkVersion();
            }
            catch (XmlRpcException e) {
                return FormValidation.ok();
            }
            if (bsess.login()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid username/password");
        }
    }
}

