/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildPipelineForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectForm;
import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.View;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPipelineView
extends View {
    private String selectedJob;
    private String noOfDisplayedBuilds;
    private String buildViewTitle = "";
    private static final Logger LOGGER = Logger.getLogger(BuildPipelineView.class.getName());
    private static final String REQ_UPSTREAM_BUILD_NUMBER = "upstreamBuildNumber";
    private static final String REQ_TRIGGER_PROJECT_NAME = "triggerProjectName";
    private static final String REQ_UPSTREAM_PROJECT_NAME = "upstreamProjectName";

    @DataBoundConstructor
    public BuildPipelineView(String name, String buildViewTitle, String selectedJob, String noOfDisplayedBuilds) {
        super(name);
        this.setBuildViewTitle(buildViewTitle);
        this.setSelectedJob(selectedJob);
        this.setNoOfDisplayedBuilds(noOfDisplayedBuilds);
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        this.selectedJob = req.getParameter("selectedJob");
        this.noOfDisplayedBuilds = req.getParameter("noOfDisplayedBuilds");
        this.buildViewTitle = req.getParameter("buildViewTitle");
    }

    public AbstractProject<?, ?> getSelectedProject() {
        AbstractProject selectedProject = null;
        if (this.getSelectedJob() != null) {
            selectedProject = (AbstractProject)super.getJob(this.getSelectedJob());
        }
        return selectedProject;
    }

    public boolean hasSelectedProject() {
        boolean result = false;
        AbstractProject testProject = this.getSelectedProject();
        if (testProject != null) {
            result = true;
        }
        return result;
    }

    public boolean hasBuildPermission(AbstractProject<?, ?> currentProject) {
        return currentProject.hasPermission(Item.BUILD);
    }

    public boolean hasConfigurePermission() {
        return this.hasPermission(CONFIGURE);
    }

    public boolean hasBuildPermission() {
        return this.hasPermission(CONFIGURE);
    }

    public List<AbstractProject<?, ?>> getDownstreamProjects(AbstractProject<?, ?> currentProject) {
        return ProjectUtil.getDownstreamProjects(currentProject);
    }

    public boolean hasDownstreamProjects(AbstractProject<?, ?> currentProject) {
        return this.getDownstreamProjects(currentProject).size() > 0;
    }

    public BuildPipelineForm getBuildPipelineForm() throws URISyntaxException {
        AbstractProject project = this.getSelectedProject();
        BuildPipelineForm buildPipelineForm = null;
        if (project != null) {
            int maxNoOfDisplayBuilds = Integer.valueOf(this.noOfDisplayedBuilds);
            int rowsAppended = 0;
            ArrayList<BuildForm> buildForms = new ArrayList<BuildForm>();
            for (AbstractBuild currentBuild : project.getBuilds()) {
                buildForms.add(new BuildForm(new PipelineBuild(currentBuild, project, null)));
                if (++rowsAppended < maxNoOfDisplayBuilds) continue;
                break;
            }
            buildPipelineForm = new BuildPipelineForm(new ProjectForm(project), buildForms);
        }
        return buildPipelineForm;
    }

    public String getProjectURL(AbstractProject<?, ?> project) throws URISyntaxException {
        return project.getUrl();
    }

    public void doManualExecution(StaplerRequest req, StaplerResponse rsp) {
        ArrayList buildActions = new ArrayList();
        int upstreamBuildNo = req.getParameter(REQ_UPSTREAM_BUILD_NUMBER) == null ? 0 : Integer.parseInt(req.getParameter(REQ_UPSTREAM_BUILD_NUMBER));
        AbstractProject triggerProject = (AbstractProject)super.getJob(req.getParameter(REQ_TRIGGER_PROJECT_NAME));
        AbstractProject upstreamProject = (AbstractProject)super.getJob(req.getParameter(REQ_UPSTREAM_PROJECT_NAME));
        AbstractBuild upstreamBuild = null;
        for (AbstractBuild tmpUpBuild : upstreamProject.getBuilds()) {
            if (tmpUpBuild.getNumber() != upstreamBuildNo) continue;
            upstreamBuild = tmpUpBuild;
            break;
        }
        Cause.UpstreamCause upstreamCause = new Cause.UpstreamCause(upstreamBuild);
        triggerProject.scheduleBuild(triggerProject.getQuietPeriod(), (Cause)upstreamCause, buildActions.toArray(new Action[buildActions.size()]));
        try {
            rsp.sendRedirect2(".");
        }
        catch (IOException e) {
            LOGGER.info(e.toString());
        }
    }

    public void invokeBuild() {
        ArrayList buildActions = new ArrayList();
        Cause.UserCause userInvokedCause = new Cause.UserCause();
        this.getSelectedProject().scheduleBuild(this.getSelectedProject().getQuietPeriod(), (Cause)userInvokedCause, buildActions.toArray(new Action[buildActions.size()]));
    }

    public String getBuildViewTitle() {
        return this.buildViewTitle;
    }

    public void setBuildViewTitle(String buildViewTitle) {
        this.buildViewTitle = buildViewTitle;
    }

    public String getNoOfDisplayedBuilds() {
        return this.noOfDisplayedBuilds;
    }

    public void setNoOfDisplayedBuilds(String noOfDisplayedBuilds) {
        this.noOfDisplayedBuilds = noOfDisplayedBuilds;
    }

    public String getSelectedJob() {
        return this.selectedJob;
    }

    public void setSelectedJob(String selectedJob) {
        this.selectedJob = selectedJob;
    }

    public Collection<TopLevelItem> getItems() {
        return Hudson.getInstance().getItems();
    }

    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    public void onJobRenamed(Item item, String oldName, String newName) {
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }
}

