/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.util.BuildUtil;
import au.com.centrumsystems.hudson.plugin.util.HudsonResult;
import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineBuild {
    private AbstractBuild<?, ?> currentBuild;
    private AbstractProject<?, ?> project;
    private AbstractBuild<?, ?> upstreamBuild;
    private String upstreamBuildResult;
    private String currentBuildResult;
    private static final Logger LOGGER = Logger.getLogger(PipelineBuild.class.getName());

    public PipelineBuild() {
    }

    public PipelineBuild(AbstractBuild<?, ?> build, AbstractProject<?, ?> project, AbstractBuild<?, ?> previousBuild) {
        this.currentBuild = build;
        this.project = project;
        this.upstreamBuild = previousBuild;
        this.currentBuildResult = "";
        this.upstreamBuildResult = "";
    }

    public PipelineBuild(FreeStyleProject project) {
        this(null, (AbstractProject<?, ?>)project, null);
    }

    public AbstractBuild<?, ?> getCurrentBuild() {
        return this.currentBuild;
    }

    public void setCurrentBuild(AbstractBuild<?, ?> currentBuild) {
        this.currentBuild = currentBuild;
    }

    public AbstractBuild<?, ?> getUpstreamBuild() {
        return this.upstreamBuild;
    }

    public void setUpstreamBuild(AbstractBuild<?, ?> upstreamBuild) {
        this.upstreamBuild = upstreamBuild;
    }

    public void setProject(AbstractProject<?, ?> currentProject) {
        this.project = currentProject;
    }

    public AbstractProject<?, ?> getProject() {
        AbstractProject currentProject = this.project == null && this.currentBuild != null ? this.currentBuild.getProject() : this.project;
        return currentProject;
    }

    private String getCurrentBuildNumber() {
        if (this.currentBuild != null) {
            return Integer.toString(this.currentBuild.getNumber());
        }
        return "";
    }

    public List<PipelineBuild> getDownstreamPipeline() {
        ArrayList<PipelineBuild> pbList = new ArrayList<PipelineBuild>();
        AbstractProject<?, ?> currentProject = this.getProject();
        List<AbstractProject<?, ?>> downstreamProjects = ProjectUtil.getDownstreamProjects(currentProject);
        for (AbstractProject<?, ?> proj : downstreamProjects) {
            AbstractBuild<?, ?> returnedBuild = null;
            if (this.currentBuild != null) {
                returnedBuild = BuildUtil.getDownstreamBuild(proj, this.currentBuild);
            }
            PipelineBuild newPB = new PipelineBuild(returnedBuild, proj, this.currentBuild);
            pbList.add(newPB);
        }
        return pbList;
    }

    public String getBuildResultURL() {
        return this.currentBuild != null ? this.currentBuild.getUrl() : "";
    }

    public String getProjectURL() {
        return this.project != null ? this.project.getUrl() : "";
    }

    public String getCurrentBuildResult() {
        if (this.currentBuildResult.isEmpty()) {
            this.currentBuildResult = this.getBuildResult(this.currentBuild);
        }
        return this.currentBuildResult;
    }

    public String getUpstreamBuildResult() {
        if (this.upstreamBuildResult.isEmpty()) {
            this.upstreamBuildResult = this.getBuildResult(this.upstreamBuild);
        }
        return this.upstreamBuildResult;
    }

    private String getBuildResult(AbstractBuild<?, ?> build) {
        String buildResult = build != null ? (build.isBuilding() ? HudsonResult.BUILDING.toString() : HudsonResult.values()[build.getResult().ordinal].toString()) : this.getPendingStatus();
        return buildResult;
    }

    private String getPendingStatus() {
        String pendingStatus = HudsonResult.PENDING.toString();
        PipelineBuild upstreamPB = this.getUpstreamPipelineBuild();
        if (upstreamPB != null && this.getUpstreamBuild() != null && this.getUpstreamBuildResult().equals(HudsonResult.SUCCESS.toString()) && ProjectUtil.isManualTrigger(this.upstreamBuild.getProject(), this.project)) {
            pendingStatus = HudsonResult.MANUAL.toString();
        }
        return pendingStatus;
    }

    public PipelineBuild getUpstreamPipelineBuild() {
        List upstreamProjects = this.getProject().getUpstreamProjects();
        PipelineBuild previousPB = new PipelineBuild();
        if (upstreamProjects.size() > 0) {
            AbstractProject previousProject = (AbstractProject)upstreamProjects.get(0);
            previousPB.setCurrentBuild(this.getUpstreamBuild());
            previousPB.setProject(previousProject);
        }
        return previousPB;
    }

    public String getBuildDuration() {
        if (this.currentBuild != null) {
            return this.currentBuild.getDurationString();
        }
        return "";
    }

    public String toString() {
        return "Project: " + this.getProject().getName() + " : Build: " + this.getCurrentBuildNumber();
    }

    public String getBuildDescription() {
        if (this.currentBuild != null) {
            return this.currentBuild.toString();
        }
        return "Pending build of project: " + this.getProject().getName();
    }

    public String getScmRevision() {
        String revNo = "No Revision";
        if (this.currentBuild != null) {
            String hgNo;
            if ("hudson.scm.SubversionSCM".equals(this.project.getScm().getType())) {
                String svnNo = this.svnNo();
                if (svnNo != null) {
                    revNo = svnNo;
                }
            } else if ("hudson.plugins.git.GitSCM".equals(this.project.getScm().getType())) {
                String gitNo = this.gitNo();
                if (gitNo != null) {
                    revNo = gitNo;
                }
            } else if ("hudson.plugins.mercurial.MercurialSCM".equals(this.project.getScm().getType()) && (hgNo = this.hgNo()) != null) {
                revNo = hgNo;
            }
        }
        return revNo;
    }

    private String hgNo() {
        InputStream inputStream = null;
        try {
            String revNo = null;
            URL url = new URL(Hudson.getInstance().getRootUrl() + this.currentBuild.getUrl() + "api/json?tree=changeSet[items[node,rev]]");
            inputStream = url.openStream();
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)inputStream));
            if (json != null) {
                try {
                    JSONArray items = json.getJSONObject("changeSet").getJSONArray("items");
                    if (items != null && items.size() >= 1) {
                        revNo = "Hg: " + items.getJSONObject(0).getString("rev") + ":" + items.getJSONObject(0).getString("node");
                    }
                }
                catch (JSONException e) {
                    LOGGER.finest("did not find svn revision in " + json);
                }
            }
            String string = revNo;
            return string;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String gitNo() {
        InputStream inputStream = null;
        try {
            String revNo = null;
            URL url = new URL(Hudson.getInstance().getRootUrl() + this.currentBuild.getUrl() + "api/json?tree=actions[lastBuiltRevision[SHA1]]");
            inputStream = url.openStream();
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)inputStream));
            if (json != null) {
                try {
                    JSONArray actions = json.getJSONArray("actions");
                    for (Object object : actions) {
                        JSONObject jsonObject;
                        if (!(object instanceof JSONObject) || !(jsonObject = (JSONObject)object).containsKey((Object)"lastBuiltRevision")) continue;
                        revNo = "Git: " + jsonObject.getJSONObject("lastBuiltRevision").getString("SHA1");
                    }
                }
                catch (JSONException e) {
                    LOGGER.finest("did not find git revision in " + json);
                }
            }
            String string = revNo;
            return string;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private String svnNo() {
        InputStream inputStream = null;
        try {
            String revNo = null;
            URL url = new URL(Hudson.getInstance().getRootUrl() + this.currentBuild.getUrl() + "api/json?tree=changeSet[revisions[revision]]");
            inputStream = url.openStream();
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)inputStream));
            if (json != null) {
                try {
                    revNo = "Svn: " + json.getJSONObject("changeSet").getJSONArray("revisions").getJSONObject(0).getString("revision");
                }
                catch (JSONException e) {
                    LOGGER.finest("did not find svn revision in " + json);
                }
            }
            String string = revNo;
            return string;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public boolean hasBuildPermission() {
        boolean buildPermission = false;
        if (!Hudson.getInstance().isUseSecurity()) {
            buildPermission = true;
        } else if (this.project != null) {
            buildPermission = this.project.hasPermission(Item.BUILD);
        }
        return buildPermission;
    }

    public boolean isManual() {
        return this.getCurrentBuildResult().equals(HudsonResult.MANUAL.toString());
    }

    public Date getStartTime() {
        return this.currentBuild != null ? this.currentBuild.getTime() : null;
    }
}

